%define _unpackaged_files_terminate_build 1
%define oname execnet
%define fname python-module-%oname
%define descr \
execnet provides carefully tested means to ad-hoc interact with Python \
interpreters across version, platform and network barriers. It provides \
a minimal and fast API targetting the following uses: \
\
* distribute tasks to local or remote processes \
* write and deploy hybrid multi-process applications \
* write scripts to administer multiple hosts

%if ""!=""
%def_without check
%else
%def_with check
%endif

Name: %fname
Version: 1.5.0
Release: alt1

%if ""==""
Summary: Rapid multi-Python deployment
Group: Development/Python
%else
Summary: Documentation for %oname
Group: Development/Documentation
%endif

License: MIT
Url: https://pypi.python.org/pypi/execnet/
Source: %name-%version.tar
Patch0: fix_test_close_initiating_remote_no_error.patch
Patch1: fix-test_popen_nice-test.patch
BuildArch: noarch

%if ""==""
%py_provides %oname
%add_python_req_skip win32event win32evtlogutil win32service
%add_python_req_skip win32serviceutil register
%if ""=="3"
# hasn't got version for Python3
%add_python_req_skip rlcompleter2
%endif
%filter_from_provides /^python(execnet\.script\.shell)/d
# IndexError: list index out of range
%filter_from_provides /^python(execnet\.script\.socketserverservice)/d
# No module named 'win32serviceutil'
%filter_from_provides /^python(execnet\.script\.quitserver)/d
# No module named 'execnet.quitserver'
%if ""=="3"
%filter_from_provides /^python(execnet\.script\.xx)/d
# depends from rlcompleter2
%endif
%endif

%if ""!=""
Conflicts: %fname < %EVR
Conflicts: %fname > %EVR
%endif

BuildRequires(pre): rpm-macros-sphinx rpm-build-python
BuildRequires: python-module-setuptools_scm
BuildRequires: python-module-apipkg
# one of the python3 tests requires python with 'apipkg' module
BuildRequires: python-module-apipkg

%if_with check
BuildRequires: python-module-tox
BuildRequires: python-module-pytest-timeout
%endif

%if ""!=""
BuildRequires: python-module-alabaster
BuildRequires: python-module-html5lib
BuildRequires: python-module-objects.inv
%endif

%description
%descr
%if ""!=""

This package contains documentation for %oname.

%package -n %fname-pickles
Summary: Pickles for %oname
Group: Development/Python

%description -n %fname-pickles
%descr

This package contains pickles for %oname.
%endif

%prep
%setup
%patch0 -p1
%patch1 -p2
%if ""!=""
%prepare_sphinx .
ln -s ../objects.inv doc/
%endif

%build
%python_build

%install
%if ""==""
%python_install
%else
export PYTHONPATH=%buildroot%python_sitelibdir
%make -C doc pickle
%make -C doc html
mkdir -p %buildroot%python_sitelibdir/%oname
cp -fR doc/_build/pickle %buildroot%python_sitelibdir/%oname/
%endif

%check
export PIP_INDEX_URL=http://host.invalid./
export PYTHONPATH=`pwd`

%if ""=="3"

# copy necessary exec deps
TOX_TESTENV_PASSENV='PYTHONPATH' tox.py3 --sitepackages \
-e py%{python_version_nodots python3} --notest
cp -T %_bindir/py.test3 .tox/py%{python_version_nodots python3}/bin/py.test

TOX_TESTENV_PASSENV='PYTHONPATH' tox.py3 --sitepackages \
-e py%{python_version_nodots python3} -v -- -v

%else

# copy necessary exec deps
TOX_TESTENV_PASSENV='PYTHONPATH' tox --sitepackages \
-e py%{python_version_nodots python} --notest
cp -T %_bindir/py.test .tox/py%{python_version_nodots python}/bin/py.test

TOX_TESTENV_PASSENV='PYTHONPATH' tox --sitepackages \
-e py%{python_version_nodots python} -v -- -v

%endif

%if ""==""

%files
%doc CHANGELOG.rst *.txt
%python_sitelibdir/%oname
%python_sitelibdir/*.egg-info*

%else

%files
%doc doc/_build/html/*

%files -n %fname-pickles
%python_sitelibdir/*/pickle
%endif

%changelog
