%define oname monkey

%def_with python3

Name: python-module-%oname
Version: 0.1
Release: alt2.2
Summary: A package that provides tools for guerilla (monkey)-patching
License: BSD
Group: Development/Python
Url: http://pypi.python.org/pypi/monkey/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

Source: %name-%version.tar
BuildArch: noarch

BuildPreReq: python-devel python-module-setuptools
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-devel python3-module-setuptools
BuildPreReq: python-tools-2to3
%endif

%description
Provides tools for guerilla (monkey)-patching.

The package provides two methods, patch and wrap, that are used to
decorate the patch method.

Patching is only allowed if a signature on the original method is
provided. Multiple signatures can be provided corresponding to various
bona fide versions of the method.

%package -n python3-module-%oname
Summary: A package that provides tools for guerilla (monkey)-patching
Group: Development/Python3

%description -n python3-module-%oname
Provides tools for guerilla (monkey)-patching.

The package provides two methods, patch and wrap, that are used to
decorate the patch method.

Patching is only allowed if a signature on the original method is
provided. Multiple signatures can be provided corresponding to various
bona fide versions of the method.

%prep
%setup

%if_with python3
cp -fR . ../python3
find ../python3 -type f -name '*.py' -exec 2to3 -w -n '{}' +
%endif

%build
%python_build

%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%python_install

%if_with python3
pushd ../python3
%python3_install
popd
%endif

%files
%doc *.txt
%python_sitelibdir/*

%if_with python3
%files -n python3-module-%oname
%doc *.txt
%python3_sitelibdir/*
%endif

%changelog
