%global pypi_name mox3
%def_disable check

Name: python-module-%pypi_name
Version: 0.26.0
Release: alt1
Summary: Mock object framework for Python
License: Apache-2.0
Group: Development/Python
Url: http://docs.openstack.org/developer/%pypi_name
Source: https://tarballs.openstack.org/%pypi_name/%pypi_name-%version.tar.gz

BuildArch:      noarch

BuildRequires(pre): rpm-macros-sphinx
BuildRequires: python-devel
BuildRequires: python-module-pbr >= 2.0.0 python-module-sphinx-devel
BuildRequires: python-module-sphinx
BuildRequires: python-module-openstackdocstheme >= 1.18.1
BuildRequires: python-module-reno
BuildRequires: python-module-setuptools
BuildRequires: python-module-fixtures >= 3.0.0 python-module-testtools >= 2.2.0
BuildRequires: python-module-mimeparse python-module-extras
BuildRequires: python-module-testrepository python-module-subunit-tests
BuildRequires: python-module-discover python-module-coverage
BuildRequires: python-module-hacking python-module-d2to1
BuildRequires: python-module-flake8 pyflakes python-tools-pep8
BuildRequires: python-module-requests

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
BuildRequires: python3-module-pbr
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-sphinx
BuildRequires: python3-module-openstackdocstheme >= 1.18.1
BuildRequires: python3-module-reno
BuildRequires: python3-module-fixtures python3-module-testtools
BuildRequires: python3-module-mimeparse python3-module-extras
BuildRequires: python3-module-testrepository python3-module-subunit-tests
BuildRequires: python3-module-discover python3-module-coverage
BuildRequires: python3-module-hacking python3-module-d2to1
BuildRequires: python3-module-flake8 python3-pyflakes python3-tools-pep8
BuildRequires: python3-module-oslosphinx python3-module-sphinx
BuildRequires: python3-module-requests

%description
Mox3 is an unofficial port of the Google mox framework
(http://code.google.com/p/pymox/) to Python 3. It was meant to be as compatible
with mox as possible, but small enhancements have been made. The library was
tested on Python version 3.2, 2.7 and 2.6.

%package tests
Summary: Tests for %pypi_name
Group: Development/Python
Requires: %name = %EVR

%description tests
Mox3 is an unofficial port of the Google mox framework
(http://code.google.com/p/pymox/) to Python 3. It was meant to be as compatible
with mox as possible, but small enhancements have been made. The library was
tested on Python version 3.2, 2.7 and 2.6.

This package contains tests for %pypi_name.

%package pickles
Summary: Pickles for %pypi_name
Group: Development/Python

%description pickles
Mox3 is an unofficial port of the Google mox framework
(http://code.google.com/p/pymox/) to Python 3. It was meant to be as compatible
with mox as possible, but small enhancements have been made. The library was
tested on Python version 3.2, 2.7 and 2.6.

This package contains pickles for %pypi_name.

%package -n python3-module-%pypi_name
Summary: Mock object framework for Python
Group: Development/Python3
%py3_provides %pypi_name

%description -n python3-module-%pypi_name
Mox3 is an unofficial port of the Google mox framework
(http://code.google.com/p/pymox/) to Python 3. It was meant to be as compatible
with mox as possible, but small enhancements have been made. The library was
tested on Python version 3.2, 2.7 and 2.6.

%package -n python3-module-%pypi_name-tests
Summary: Tests for %pypi_name
Group: Development/Python3
Requires: python3-module-%pypi_name = %EVR

%description -n python3-module-%pypi_name-tests
Mox3 is an unofficial port of the Google mox framework
(http://code.google.com/p/pymox/) to Python 3. It was meant to be as compatible
with mox as possible, but small enhancements have been made. The library was
tested on Python version 3.2, 2.7 and 2.6.

This package contains tests for %pypi_name.

%prep
%setup -n %pypi_name-%version

cp -fR . ../python3

%prepare_sphinx doc
ln -s ../objects.inv doc/source/

%build
%python_build


pushd ../python3
%python3_build
popd

%install
%python_install

export PYTHONPATH=%buildroot%python_sitelibdir
pushd doc/source
sphinx-build -b pickle -d build/doctrees . build/pickle
sphinx-build -b html -d build/doctrees . build/html
cp -fR build/pickle %buildroot%python_sitelibdir/%pypi_name/
popd

pushd ../python3
%python3_install
popd

%check
python setup.py test
rm -fR build
py.test


pushd ../python3
python3 setup.py test
rm -fR build
py.test3
popd


%files
%doc COPYING.txt ChangeLog AUTHORS README.rst doc/source/build/html
%python_sitelibdir/*
%exclude %python_sitelibdir/*/tests
%exclude %python_sitelibdir/*/pickle

%files pickles
%python_sitelibdir/*/pickle

%files tests
%python_sitelibdir/*/tests

%files -n python3-module-%pypi_name
%doc COPYING.txt ChangeLog AUTHORS README.rst doc/source/build/html
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/tests

%files -n python3-module-%pypi_name-tests
%python3_sitelibdir/*/tests

%changelog
