%define _unpackaged_files_terminate_build 1

%define oname pandas

%def_with python3
%def_disable check
%def_without docs

Name: python-module-%oname
Version: 0.23.4
Release: alt1

Summary: Python Data Analysis Library
License: BSD
Group: Development/Python

Url: http://pandas.pydata.org/

# https://github.com/pandas-dev/pandas.git
Source: %name-%version.tar
Patch1: %oname-alt-docs.patch
Patch2: %oname-alt-static-variables.patch

BuildRequires(pre): rpm-build-python
BuildRequires: python-devel
BuildRequires: libnumpy-devel python-module-Cython python-module-notebook python-module-numpy-testing python-module-pathlib
BuildRequires: gcc-c++
BuildRequires: xvfb-run python2.7(nbsphinx)
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
BuildRequires: libnumpy-py3-devel python3-module-Cython python3-module-notebook python3-module-numpy-testing
BuildRequires: xvfb-run python3(nbsphinx)
BuildRequires: python3(scipy) python3(xlrd) python3(tables.tests)
%if_enabled check
BuildRequires: python3(openpyxl)
%endif
%if_with docs
BuildRequires(pre): rpm-macros-sphinx
BuildRequires: python-module-objects.inv
BuildRequires: pandoc
%endif
%endif

%setup_python_module %oname
%py_requires pytz pandas.util.testing dateutil numpy sqlalchemy numexpr
%py_requires scipy boto bs4 xlrd openpyxl xlsxwriter xlwt httplib2
%py_requires oauth2client apiclient gflags tables
%py_requires statsmodels.stats.multitest

%description
pandas is an open source, BSD-licensed library providing
high-performance, easy-to-use data structures and data analysis tools
for the Python programming language.

%if_with python3
%package -n python3-module-%oname
Summary: Python Data Analysis Library
Group: Development/Python3
%add_python3_req_skip feather
%py3_requires pytz pandas.util.testing dateutil numpy sqlalchemy numexpr
%py3_requires scipy boto bs4 xlrd openpyxl xlsxwriter xlwt httplib2
%py3_requires oauth2client apiclient gflags tables statsmodels
%py3_requires statsmodels.stats.multitest

%description -n python3-module-%oname
pandas is an open source, BSD-licensed library providing
high-performance, easy-to-use data structures and data analysis tools
for the Python programming language.

%package -n python3-module-%oname-tests
Summary: Tests for pandas
Group: Development/Python3
Requires: python3-module-%oname = %EVR
%py3_requires numpy.ma.testutils pymysql psycopg2

%description -n python3-module-%oname-tests
pandas is an open source, BSD-licensed library providing
high-performance, easy-to-use data structures and data analysis tools
for the Python programming language.

This package contains tests for pandas.

%package -n python3-module-%oname-docs
Summary: Documentation for pandas
Group: Development/Documentation
BuildArch: noarch

%description -n python3-module-%oname-docs
pandas is an open source, BSD-licensed library providing
high-performance, easy-to-use data structures and data analysis tools
for the Python programming language.

This package contains documentation for pandas.
%endif

%package tests
Summary: Tests for pandas
Group: Development/Python
Requires: %name = %EVR
%py_requires numpy.ma.testutils pymysql psycopg2

%description tests
pandas is an open source, BSD-licensed library providing
high-performance, easy-to-use data structures and data analysis tools
for the Python programming language.

This package contains tests for pandas.

%prep
%setup
%patch1 -p1
%patch2 -p1

# fix version info
sed -i \
	-e "s/git_refnames\s*=\s*\"[^\"]*\"/git_refnames = \" \(tag: v%version\)\"/" \
	%oname/_version.py

%if_with python3
cp -fR . ../python3

%if_with docs
pushd ../python3
%prepare_sphinx doc
ln -s ../objects.inv doc/source/
sed -i 's|@PYPATH@|%buildroot%python3_sitelibdir|' doc/make.py
popd
%endif

%endif

%build
%add_optflags -fno-strict-aliasing
%python_build_debug

%if_with python3
pushd ../python3
%python3_build_debug
popd
%endif

%install
%python_install

%if_with python3
pushd ../python3
%python3_install

# It is the file in the package whose name matches the format emacs or vim uses 
# for backup and autosave files. It may have been installed by  accident.
find $RPM_BUILD_ROOT \( -name '.*.swp' -o -name '#*#' -o -name '*~' \) -print -delete
# failsafe cleanup if the file is declared as %%doc
find . \( -name '.*.swp' -o -name '#*#' -o -name '*~' \) -print -delete

%if_with docs
pushd doc
PYTHONPATH=$(echo ../build/lib.*) xvfb-run ./make.py html
popd
%endif

popd
%endif

%check
xvfb-run python setup.py test
%if_with python3
pushd ../python3
xvfb-run python3 setup.py test
popd
%endif

%files
%doc *.md
%python_sitelibdir/%oname
%python_sitelibdir/%oname-%version-py*.egg-info
%exclude %python_sitelibdir/*/tests
%exclude %python_sitelibdir/*/*/test*

%files tests
%python_sitelibdir/*/tests
%python_sitelibdir/*/*/test*

%if_with python3
%files -n python3-module-%oname
%doc *.md
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version-py*.egg-info
%exclude %python3_sitelibdir/*/tests
%exclude %python3_sitelibdir/*/*/test*
%exclude %python3_sitelibdir/*/*/*/test*

%files -n python3-module-%oname-tests
%python3_sitelibdir/*/tests
%python3_sitelibdir/*/*/test*
%python3_sitelibdir/*/*/*/test*

%if_with docs
%files -n python3-module-%oname-docs
%doc ../python3/doc/build/html
#doc doc/source
#doc examples
%endif
%endif

%changelog
