%define _unpackaged_files_terminate_build 1
%define oname paramiko

%def_with check

Name: python-module-%oname
Version: 2.4.2
Release: alt1

Summary: SSH2 protocol for python
License: GPL
Group: Development/Python
# Source-git: https://github.com/paramiko/paramiko.git
Url: http://www.paramiko.org/

Source: %name-%version.tar
Patch: %name-%version-alt.patch

BuildRequires(pre): rpm-build-python3

%if_with check
BuildRequires: python-module-pytest
BuildRequires: python-module-cryptography
BuildRequires: python-module-pyasn1
BuildRequires: python-module-bcrypt
BuildRequires: python-module-pynacl
BuildRequires: python-module-mock
BuildRequires: python3-module-pytest
BuildRequires: python3-module-cryptography
BuildRequires: python3-module-pyasn1
BuildRequires: python3-module-bcrypt
BuildRequires: python3-module-pynacl
BuildRequires: python3-module-mock
%endif

BuildArch: noarch

%description
paramiko is a module for python that implements the SSH2 protocol for secure
(encrypted and authenticated) connections to remote machines. It is written
entirely in python (no C or platform-dependent code).

This module is built for python 2

%package -n python3-module-%oname
Summary: SSH2 protocol for python3
Group: Development/Python3

%description -n python3-module-%oname
paramiko is a module for python that implements the SSH2 protocol for secure
(encrypted and authenticated) connections to remote machines. It is written
entirely in python (no C or platform-dependent code).

This module is built for python 3

%prep
%setup
%patch -p1

cp -a . ../python3

%build
%python_build

pushd ../python3
%python3_build
popd

%install
%python_install

pushd ../python3
%python3_install
popd

%check
LC_ALL=en_US.UTF-8 py.test -vv

pushd ../python3
LC_ALL=en_US.UTF-8 py.test3 -vv
popd

%files
%doc README.rst LICENSE
%python_sitelibdir/paramiko/
%python_sitelibdir/paramiko-*.egg-info/

%files -n python3-module-%oname
%doc README.rst LICENSE
%python3_sitelibdir/paramiko/
%python3_sitelibdir/paramiko-*.egg-info/

%changelog
