%define major 2.28

Name: python-module-pygnome
Version: %major.1
Release: alt3

Summary: Set of bindings for the GNOME2 platform library
License: LGPL
Group: Development/Python
Url: http://www.pygtk.org/

Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

Source: http://ftp.gnome.org/pub/GNOME/sources/gnome-python/%major/gnome-python-%version.tar.bz2

%setup_python_module pygnome

%define python_gnome_dir %python_sitelibdir/gtk-2.0/gnome

Obsoletes: gnome-python
Obsoletes: gnome-python2
Obsoletes: %name-zvt
Obsoletes: %name-nautilus
Provides: gnome-python2 = %version-%release

BuildPreReq: python-module-pygtk-devel >= 2.13.0
BuildPreReq: python-module-pygobject-devel >= 2.17.0
BuildRequires: python-module-pyorbit-devel
BuildRequires: gnome-vfs-devel libgnomeui-devel

%description
This package is a set of bindings for the Gnome platform libraries
called PyGNOME. It builds on top of the PyGTK bindings for GTK and the
PyORBit bindings for ORBit2.

PyGNOME is an extension module for Python that provides access to the
base GNOME libraries, so you have access to more widgets, a simple
configuration interface, and metadata support.

%package devel
Summary: files needed to build wrappers for GNOME libraries
Group: Development/Python
Requires: %name = %version-%release

%description devel
This package contains files required to build wrappers for GNOME
libraries so that they interoperate with pygnome.

%package canvas
Summary: Python bindings for the GNOME Canvas
Group: Development/Python
Requires: %name = %version-%release
Obsoletes: gnome-python2-canvas
Provides: gnome-python2-canvas

%description canvas
This module contains a wrapper that allows use of the GNOME Canvas
in Python.

%package bonobo
Summary: Python bindings for interacting with bonobo
Group: Development/Python
Obsoletes: gnome-python2-bonobo
Provides: gnome-python2-bonobo

%description bonobo
This module contains a wrapper that allows the creation of bonobo
components and the embedding of bonobo components in Python.

%package gconf
Summary: Python bindings for interacting with GConf
Group: Development/Python
Requires: %name = %version-%release
Obsoletes: gnome-python2-gconf
Provides: gnome-python2-gconf

%description gconf
This module contains a wrapper that allows the use of GConf via Python.

%package gnome-vfs
Summary: Python bindings for interacting with gnome-vfs
Group: Development/Python
Requires: %name = %version-%release

%description gnome-vfs
This module contains a wrapper that allows the use of gnome-vfs via Python.

%prep
%setup -q -n gnome-python-%version

%build
%configure
%make_build

%install
%makeinstall
find %buildroot -name '*.la' -exec rm {} \;

%files
%dir %python_gnome_dir
%python_gnome_dir/__init__.*
%python_gnome_dir/_gnome.so
%python_gnome_dir/ui.so
%python_gnome_dir/vfs.*
%python_gnome_dir/canvas.*
%doc AUTHORS ChangeLog README NEWS

%files devel
%doc examples/*
%_includedir/gnome-python-2.0/
%_pkgconfigdir/gnome-python-2.0.pc
%_datadir/pygtk/2.0/argtypes/
%_datadir/pygtk/2.0/defs/*

%files canvas
%python_sitelibdir/gtk-2.0/gnomecanvas.so

%files bonobo
%python_sitelibdir/gtk-2.0/bonobo/

%files gconf
%python_sitelibdir/gtk-2.0/gconf*

%files gnome-vfs
%_libdir/gnome-vfs-2.0/modules/libpythonmethod.so
%python_sitelibdir/gtk-2.0/gnomevfs/

%changelog
