%def_disable snapshot

%define _name pygobject
%define ver_major 3.32
%define api_ver 3.0
%define gtk_api_ver 3.0
%def_enable pycairo
%def_disable devel_doc
%def_enable tests
%def_disable check

Name: python-module-%{_name}3
Version: %ver_major.2
Release: alt2

Summary: Python bindings for GObject
Group: Development/Python
License: LGPL
Url: http://www.pygtk.org/

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz
%else
Source: %_name-%version.tar
%endif
Patch: pygobject-3.38.0-alt-meson-0.55_build.patch

%setup_python_module pygobject3

%add_findprov_lib_path %python_sitelibdir/gi
%add_findprov_lib_path %python_sitelibdir/gtk-2.0

%add_findprov_lib_path %python3_sitelibdir/gi
%add_findprov_lib_path %python3_sitelibdir/gtk-2.0

Requires: typelib(GdkX11) = %gtk_api_ver
%add_typelib_req_skiplist typelib(Foo)
%filter_from_requires /Gst.*/d

%define glib_ver 2.48.0
%define gi_ver 1.46.0
%define pycairo_ver 1.11.1

BuildRequires(pre): meson rpm-build-gir rpm-build-python rpm-build-python3
BuildRequires: gnome-common gtk-doc
BuildRequires: glib2-devel >= %glib_ver libgio-devel libffi-devel
BuildRequires: python-devel python-modules-encodings python-module-pytest
%{?_enable_pycairo:BuildRequires: python-module-pycairo-devel >= %pycairo_ver libcairo-gobject-devel}
BuildRequires: gobject-introspection-devel >= %gi_ver
# python3
BuildRequires: python3-devel python3-module-pytest %{?_enable_pycairo:python3-module-pycairo-devel}
%{?_enable_check:BuildRequires: xvfb-run dbus-tools-gui libgtk+3-gir-devel glibc-i18ndata}

%description
GObject is a object system used by GTK+, GStreamer and other libraries.

PyGObject provides a convenient wrapper for use in Python programs when
accessing GObject libraries.

PyGObject now dynamically accesses any GObject libraries that uses
GObject Introspection. It replaces the need for separate modules such as
PyGTK, GIO and python-gnome to build a full GNOME 3.0 application. Once
new functionality is added to gobject library it is instantly available
as a Python API without the need for intermediate Python glue.

%package pygtkcompat
Summary: PyGTK compatibility layer for PyGObject
Group: Development/Python
Requires: %name = %version-%release

%description pygtkcompat
PyGTK compatibility layer.
It is recommended to not depend on this layer, but only use it as an
intermediate step when porting your application to PyGI. Compatibility
might never be 100%%, but the aim is to make it possible to run a well
behaved PyGTK application mostly unmodified on top of PyGI.

%package common-devel
Summary: Common development files for %_name
Group: Development/Python

%description common-devel
Common development files for %_name used for both python2 and python3.

%package devel
Summary: Development files for %name
Group: Development/Python
BuildArch: noarch
Requires: %name = %version-%release
Requires: %name-common-devel = %version-%release

%description devel
Development files for %name.

%package -n python3-module-%{_name}3
Summary: Python3 bindings for GObject
Group: Development/Python3
Requires: typelib(GdkX11) = %gtk_api_ver

%description -n python3-module-%{_name}3
GObject is a object system used by GTK+, GStreamer and other libraries.

PyGObject provides a convenient wrapper for use in Python3 programs when
accessing GObject libraries.

PyGObject now dynamically accesses any GObject libraries that uses
GObject Introspection. It replaces the need for separate modules such as
PyGTK, GIO and python-gnome to build a full GNOME 3.0 application. Once
new functionality is added to gobject library it is instantly available
as a Python API without the need for intermediate Python glue.

%package -n python3-module-%{_name}3-pygtkcompat
Summary: PyGTK compatibility layer for PyGObject
Group: Development/Python3
Requires: python3-module-%{_name}3 = %version-%release

%description -n python3-module-%{_name}3-pygtkcompat
PyGTK compatibility layer.
It is recommended to not depend on this layer, but only use it as an
intermediate step when porting your application to PyGI. Compatibility
might never be 100%%, but the aim is to make it possible to run a well
behaved PyGTK application mostly unmodified on top of PyGI.

%package -n python3-module-%{_name}3-devel
Summary: Development files for python3-module-%{_name}3
Group: Development/Python3
BuildArch: noarch
Requires: python3-module-%{_name}3 = %version-%release
Requires: %name-common-devel = %version-%release

%description -n python3-module-%{_name}3-devel
Development files for python3-module-%{_name}3.

%package devel-doc
Summary: Development documentation for %_name
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name-common-devel < %version-%release

%description devel-doc
Development documentation for %_name.

%prep
%setup -n %_name-%version
%patch -p1
%setup -D -c -n %_name-%version
mv %_name-%version py3build
pushd py3build
%patch -p1
popd

%build
%define opts %{?_disable_pycairo:-Dpycairo=false} %{?_disable_tests:-Dtests=false}
%meson %opts -Dpython=python
%meson_build

pushd py3build
export PYTHON=python3
%meson %opts
%meson_build
popd

%install
%meson_install

pushd py3build
%meson_install
popd

%check
xvfb-run %meson_test

pushd py3build
xvfb-run %meson_test
popd

%files
%python_sitelibdir/gi/
%python_sitelibdir/*.egg-info
%exclude %python_sitelibdir/gi/pygtkcompat.py*

%files pygtkcompat
%python_sitelibdir/pygtkcompat/
%python_sitelibdir/gi/pygtkcompat.py*

%files common-devel
%_includedir/%_name-%api_ver/
%_pkgconfigdir/%_name-%api_ver.pc
%doc README* NEWS examples

%files devel

%files -n python3-module-%{_name}3
%python3_sitelibdir/gi/
%python3_sitelibdir/*.egg-info
%exclude %python3_sitelibdir/gi/pygtkcompat.py*

%files -n python3-module-%{_name}3-pygtkcompat
%python3_sitelibdir/pygtkcompat/
%python3_sitelibdir/gi/pygtkcompat.py*

%files -n python3-module-%{_name}3-devel

%if_enabled devel_doc
%files devel-doc
%_datadir/gtk-doc/html/%_name/
%endif

%changelog
