%define oname pysqlite2
%define fname python-module-%oname
%define descr \
Pysqlite is an interface to the SQLite 3.0  database server for Python. \
It aims to be fully compliant with Python database API version 2.0 \
while also exploiting the unique features of SQLite 3.0.

Name: %fname-docs
Version: 2.8.3
Release: alt1

%if "-docs"==""
Summary: Python interface to SQLite 3.0
Group: Development/Python
%else
Summary: Documentation for %oname
Group: Development/Documentation
%endif

License: zlib/libpng license
Url: http://pypi.python.org/pypi/pysqlite/
Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires(pre): rpm-macros-sphinx
BuildPreReq: python-module-sphinx-devel texlive-latex-recommended
BuildRequires: libsqlite3-devel

%if "-docs"!=""
Conflicts: %fname < %EVR
Conflicts: %fname > %EVR
%endif

%description
%descr
%if "-docs"!=""

This package contains documentation for %oname.

%package -n %fname-pickles
Summary: Pickles for %oname
Group: Development/Python

%description -n %fname-pickles
%descr

This package contains pickles for %oname.
%else

%package tests
Summary: Tests for %oname
Group: Development/Python
Requires: %name = %EVR

%description tests
%descr

This package contains tests for %oname.
%endif

%prep
%setup
%patch -p1
%if "-docs"!=""
%prepare_sphinx doc/sphinx
%endif

%build
%add_optflags -fno-strict-aliasing
%if "-docs"==""
%python_build
%else
%make -C doc/sphinx html
%endif

%install
%if "-docs"==""
%python_install
%else
mkdir -p %buildroot%python_sitelibdir/%oname
cp -fR doc/sphinx/.build/pickle %buildroot%python_sitelibdir/%oname/
%endif

%if "-docs"==""
%files
%doc LICENSE PKG-INFO doc/default.css doc/docutils.css
%python_sitelibdir/*
%exclude %python_sitelibdir/%oname/test

%files tests
%python_sitelibdir/%oname/test

%else

%files
%doc doc/sphinx/.build/html

%files -n %fname-pickles
%python_sitelibdir/%oname/pickle
%endif

%changelog
