%def_with python3

%define oname pytest-runner

Name: python-module-%oname
Version: 2.9
Release: alt1.1

Summary: Setup scripts can use pytest-runner to add setup.py test support for pytest runner
License: ISC
Group: Development/Python

Url: https://pypi.python.org/pypi/%oname/
Packager: Python Development Team <python at packages.altlinux.org>

Source: https://pypi.python.org/packages/11/d4/c335ddf94463e451109e3494e909765c3e5205787b772e3b25ee8601b86a/%oname-%version.tar.gz

BuildArch: noarch

%if_with python3
BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-devel python3-module-setuptools python3-module-setuptools_scm
BuildRequires: python3-module-pytest
%endif
BuildPreReq: python-devel python-module-setuptools python-module-setuptools_scm
BuildRequires: python-module-pytest

%py_provides ptr

%description
Setup scripts can use pytest-runner to add setup.py test support for pytest
runner.

%if_with python3
%package -n python3-module-%oname
Summary: Setup scripts can use pytest-runner to add setup.py test support for pytest runner
Group: Development/Python3
%py3_provides ptr

%description -n python3-module-%oname
Setup scripts can use pytest-runner to add setup.py test support for pytest
runner.
%endif

%prep
%setup -n %oname-%version
%if_with python3
rm -fR ../python3-module-%oname-%version
cp -fR . ../python3-module-%oname-%version
%endif

%build
%python_build_debug

%if_with python3
pushd ../python3-module-%oname-%version
%python3_build_debug
popd
%endif

%install
%python_install

%if_with python3
pushd ../python3-module-%oname-%version
%python3_install
popd
%endif

%check
python setup.py test
%if_with python3
python3 setup.py test
%endif

%files
%python_sitelibdir/*

%if_with python3
%files -n python3-module-%oname
%python3_sitelibdir/*
%endif

%changelog
