%define _unpackaged_files_terminate_build 1
%define oname pytest-virtualenv

%def_with check

Name: python-module-%oname
Version: 1.6.0
Release: alt2

Summary: Virtualenv fixture for py.test
License: MIT
Group: Development/Python
# Source-git: https://github.com/manahl/pytest-plugins.git
Url: https://pypi.python.org/pypi/pytest-virtualenv

Source: %oname-%version.tar

BuildRequires(pre): rpm-build-python3

%if_with check
BuildRequires: python2.7(mock)
BuildRequires: python2.7(pytest_fixture_config)
BuildRequires: python2.7(pytest_shutil)
BuildRequires: python2.7(virtualenv)
BuildRequires: python3(mock)
BuildRequires: python3(pytest_fixture_config)
BuildRequires: python3(pytest_shutil)
BuildRequires: python3(tox)
%endif

BuildArch: noarch

%description
Create a Python virtual environment in your test that cleans up on teardown.
The fixture has utility methods to install packages and list what's installed.

%package -n python3-module-%oname
Summary: Virtualenv fixture for py.test
Group: Development/Python3

%description -n python3-module-%oname
Create a Python virtual environment in your test that cleans up on teardown.
The fixture has utility methods to install packages and list what's installed.

%prep
%setup -n %oname-%version

# fix dependency
sed -i -e 's:setuptools-git:setuptools:g' \
	common_setup.py
cp -fR . ../python3

%build
%python_build

pushd ../python3
%python3_build
popd

%install
pushd ../python3
%python3_install
popd

%python_install

%check
cat > tox.ini <<EOF
[tox]
envlist = py27,py36,py37

[testenv]
commands =
    {envpython} -m pytest {posargs:-vra}
EOF
export PIP_NO_INDEX=YES
export TOXENV=py%{python_version_nodots python},py%{python_version_nodots python3}
tox.py3 --sitepackages -p auto -o -v

%files
%doc LICENSE *.md
%python_sitelibdir/pytest_virtualenv.py*
%python_sitelibdir/pytest_virtualenv-%version-py%_python_version.egg-info/

%files -n python3-module-%oname
%doc LICENSE *.md
%python3_sitelibdir/pytest_virtualenv.py
%python3_sitelibdir/__pycache__/pytest_virtualenv.cpython-*
%python3_sitelibdir/pytest_virtualenv-%version-py%_python3_version.egg-info/

%changelog
