%define _unpackaged_files_terminate_build 1
%define oname simplejson

%def_with python3

Name: python-module-%oname
Version: 3.15.0
Release: alt1.qa1%ubt
Summary: Simplejson is a simple, fast, extensible JSON encoder/decoder for Python
License: MIT/X Consortium
Group: Development/Python
Url: https://simplejson.readthedocs.io/

# https://github.com/simplejson/simplejson.git
Source: %name-%version.tar
Patch: %oname-3.5.3-alt-python3.patch

BuildRequires(pre): rpm-build-ubt
BuildRequires: python-devel python-module-setuptools python-module-sphinx
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-dev python3-module-setuptools
%endif


%description
Simplejson is a simple, fast, complete, correct and extensible JSON
encoder and decoder for Python 2.3+. It is pure Python code with no
dependencies.

%package -n python3-module-%oname
Summary: Simplejson is a simple, fast, extensible JSON encoder/decoder for Python
Group: Development/Python3

%description -n python3-module-%oname
Simplejson is a simple, fast, complete, correct and extensible JSON
encoder and decoder for Python 2.3+. It is pure Python code with no
dependencies.

%package doc
Summary: Documentation for %name
Group: Development/Python
BuildArch: noarch

%description doc
Simplejson is a simple, fast, complete, correct and extensible JSON
encoder and decoder for Python 2.3+. It is pure Python code with no
dependencies.

This package contains documentation for simplejson.

%prep
%setup

%if_with python3
cp -fR . ../python3
pushd ../python3
%patch -p2
popd
%endif

%build
%add_optflags -fno-strict-aliasing
%python_build_debug

%if_with python3
pushd ../python3
%python3_build_debug
popd
%endif

./scripts/make_docs.py

%install
%python_install

%if_with python3
pushd ../python3
%python3_install
popd
%endif

%check
python setup.py test
%if_with python3
pushd ../python3
python3 setup.py test
popd
%endif

%files
%python_sitelibdir/%oname/
%exclude %python_sitelibdir/%oname/tests
%python_sitelibdir/*.egg-info

%files doc
%doc docs/*

%if_with python3
%files -n python3-module-%oname
%python3_sitelibdir/%oname/
%exclude %python3_sitelibdir/%oname/tests
%python3_sitelibdir/*.egg-info
%endif

%changelog
