%define _unpackaged_files_terminate_build 1
%define oname six

%def_with check

Name: python-module-%oname
Version: 1.12.0
Release: alt1

Summary: Python 2 and 3 compatibility utilities
License: MIT
Group: Development/Python

BuildArch: noarch
Url: http://pypi.python.org/pypi/six

# Url: https://github.com/benjaminp/six
Source: %name-%version.tar
Source2: move.list

%define move_list %(echo `cat %{SOURCE2}`)

%py_provides %move_list

BuildRequires(pre): rpm-build-python3

# for test suite
%if_with check
BuildRequires: python-module-pytest
BuildRequires: python-modules-tkinter
BuildRequires: python3-modules-tkinter
BuildRequires: python3-module-tox
%endif

%description
Six is a Python 2 and 3 compatibility library. It provides utility
functions for smoothing over the differences between the Python versions
with the goal of writing Python code that is compatible on both Python
versions. See the documentation for more information on what is
provided.

%package -n python3-module-%oname
Summary: Python 2 and 3 compatibility utilities
Group: Development/Python3
%py3_provides %move_list

%description -n python3-module-%oname
Six is a Python 2 and 3 compatibility library. It provides utility
functions for smoothing over the differences between the Python versions
with the goal of writing Python code that is compatible on both Python
versions. See the documentation for more information on what is
provided.

%prep
%setup

rm -rf ../python3
cp -a . ../python3

%build
%python_build

pushd ../python3
%python3_build
popd

%install
%python_install

pushd ../python3
%python3_install
popd
# check actual state of things regarding to provides
set -o pipefail
PYTHONPATH="$(pwd)" python3 -c "import six;assert six.__version__==\"%version\";modules=six._importer.known_modules.keys();print(*modules, sep='\n')" | sort > move.actual.list
set +o pipefail
cat %SOURCE2 | sort > move.expected.list
diff -yq move.expected.list move.actual.list

%check
export PIP_NO_INDEX=YES
export TOXENV=py%{python_version_nodots python},py%{python_version_nodots python3}
tox.py3 --sitepackages -p auto -o -v

%files
%doc README.rst documentation/index.rst
%python_sitelibdir/six.py*
%python_sitelibdir/six-*.egg-info/

%files -n python3-module-%oname
%doc README.rst documentation/index.rst
%python3_sitelibdir/six.py
%python3_sitelibdir/__pycache__/
%python3_sitelibdir/six-*.egg-info/

%changelog
