%define _unpackaged_files_terminate_build 1
%define oname zope.annotation

%def_with check

Name: python-module-%oname
Version: 4.6.0
Release: alt2%ubt

Summary: Object annotation mechanism
License: ZPLv2.1
Group: Development/Python
# Source-git: https://github.com/zopefoundation/zope.annotation.git
Url: http://pypi.python.org/pypi/zope.annotation

Source: %name-%version.tar
Patch: %name-%version-alt.patch

BuildRequires(pre): rpm-build-ubt
BuildRequires(pre): rpm-build-python
BuildRequires(pre): rpm-build-python3

BuildRequires: python-module-setuptools
BuildRequires: python-module-zope.interface
BuildRequires: python-module-zope.component
BuildRequires: python-module-zope.location
BuildRequires: python-module-zope.proxy
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-zope.interface
BuildRequires: python3-module-zope.component
BuildRequires: python3-module-zope.location
BuildRequires: python3-module-zope.proxy

%if_with check
BuildRequires: python-module-tox
BuildRequires: python-module-virtualenv
BuildRequires: python-module-BTrees
BuildRequires: python-module-coverage
BuildRequires: python-module-zope.testing
BuildRequires: python-module-zope.testrunner
BuildRequires: python3-module-tox
BuildRequires: python3-module-virtualenv
BuildRequires: python3-module-BTrees
BuildRequires: python3-module-coverage
BuildRequires: python3-module-zope.testing
BuildRequires: python3-module-zope.testrunner
%endif

%py_requires zope.interface zope.component zope.location zope.proxy

%description
This package provides a mechanism to store additional information about
objects without need to modify object class.

%package -n python3-module-%oname
Summary: Object annotation mechanism
Group: Development/Python3

%description -n python3-module-%oname
This package provides a mechanism to store additional information about
objects without need to modify object class.

%package -n python3-module-%oname-tests
Summary: Tests for %oname
Group: Development/Python3
Requires: python3-module-%oname = %EVR
%py3_requires zope.testing zope.testrunner

%description -n python3-module-%oname-tests
This package contains tests for %oname

%package tests
Summary: Tests for %oname
Group: Development/Python
Requires: %name = %EVR
%py_requires zope.testing zope.testrunner

%description tests
This package contains tests for %oname

%prep
%setup
%patch0 -p1

rm -rf ../python3
cp -a . ../python3

%build
%python_build

pushd ../python3
%python3_build
popd

%install
%python_install
%if "%python_sitelibdir_noarch" != "%python_sitelibdir"
install -d %buildroot%python_sitelibdir
mv %buildroot%python_sitelibdir_noarch/* \
	%buildroot%python_sitelibdir/
%endif

pushd ../python3
%python3_install
popd
%if "%python3_sitelibdir_noarch" != "%python3_sitelibdir"
install -d %buildroot%python3_sitelibdir
mv %buildroot%python3_sitelibdir_noarch/* \
	%buildroot%python3_sitelibdir/
%endif

%check
export PIP_INDEX_URL=http://host.invalid./

export PYTHONPATH=%python_sitelibdir_noarch:%python_sitelibdir:src
TOX_TESTENV_PASSENV='PYTHONPATH' tox --sitepackages -e py%{python_version_nodots python} -v

pushd ../python3
export PYTHONPATH=%python3_sitelibdir_noarch:%python3_sitelibdir:src
TOX_TESTENV_PASSENV='PYTHONPATH' tox.py3 --sitepackages -e py%{python_version_nodots python3} -v
popd

%files
%doc *.txt *.rst
%python_sitelibdir/*
%exclude %python_sitelibdir/*.pth
%exclude %python_sitelibdir/*/*/tests

%files tests
%python_sitelibdir/*/*/tests

%files -n python3-module-%oname
%doc *.txt *.rst
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*.pth
%exclude %python3_sitelibdir/*/*/tests

%files -n python3-module-%oname-tests
%python3_sitelibdir/*/*/tests

%changelog
