%define _unpackaged_files_terminate_build 1
%define oname zope.i18nmessageid
%define fname python-module-%oname
%define descr \
This package provides facilities for *declaring* messages within \
program source text;  translation of the messages is the responsiblity \
of the 'zope.i18n' package.

%def_with check

Name: %fname-docs
Version: 4.3.1
Release: alt1

%if "-docs"==""
Summary: Message Identifiers for internationalization
Group: Development/Python
%else
Summary: Documentation for %oname
Group: Development/Documentation
%endif

License: ZPLv2.1
# Source-git https://github.com/zopefoundation/zope.i18nmessageid.git
Url: http://pypi.python.org/pypi/zope.i18nmessageid
Source: %name-%version.tar

BuildRequires(pre): rpm-macros-sphinx rpm-build-python
BuildRequires: python-dev python-module-sphinx python-module-sphinx-devel python-module-setuptools

%if_with check
BuildRequires: python-module-zope.testing python-module-zope.testrunner
%endif

%if "-docs"!=""
Conflicts: %fname < %EVR
Conflicts: %fname > %EVR
BuildArch: noarch
%endif

%description
%descr

%if "-docs"!=""
This package contains documentation for %oname.

%package -n %fname-pickles
Summary: Pickles for Zope Configuration Markup Language (ZCML)
Group: Development/Python

%description -n %fname-pickles
%descr

This package contains pickles for %oname.

%else

%package tests
Summary: Tests for %oname
Group: Development/Python
Requires: %name = %EVR

%description tests
%descr

This package contains tests for %oname.

%endif

%prep
%setup
%if "-docs"!=""
%prepare_sphinx .
ln -s ../objects.inv docs/
%endif

%build
%if "-docs"==""
%add_optflags -fno-strict-aliasing
%python_build
%else
%make -C docs pickle
%make -C docs html
%endif

%install
%if "-docs"==""
%python_install
%else
install -d %buildroot%python_sitelibdir/%oname
cp -fR docs/_build/pickle %buildroot%python_sitelibdir/%oname/
%endif

%if "-docs"==""
%check
export PYTHONPATH=src
python setup.py test -v

%files
%doc *.txt *.rst
%python_sitelibdir/*
%exclude %python_sitelibdir/zope/i18nmessageid/tests.*

%files tests
%python_sitelibdir/zope/i18nmessageid/tests.*

%else

%files
%doc docs/_build/html

%files -n %fname-pickles
%python_sitelibdir/*/pickle
%endif

%changelog
