%define _unpackaged_files_terminate_build 1

%def_enable bootstrap

%define oname Enable
Name: python3-module-%oname
Version: 4.8.1
Release: alt3
Summary: Drawing and interaction packages

Group: Development/Python3
License: BSD and GPLv2
URL: https://github.com/enthought/enable/

# https://github.com/enthought/enable.git
Source: enable-%version.tar

Patch: use_system_freetype.patch
Patch1: 2c9b2090edd03e14857f99778350daed3ccf8e5a.patch

BuildRequires: gcc-c++ swig
BuildRequires: libX11-devel libGL-devel libGLU-devel
BuildRequires: libfreetype-devel
BuildRequires: libopenblas-devel liblapack-devel

%if_disabled bootstrap
BuildRequires: python-module-Pyrex
BuildRequires: python-module-sphinx-devel python-module-Pygments
BuildRequires: python-module-traits fonts-ttf-PT
%endif

BuildRequires(pre): rpm-build-python3
BuildRequires: libnumpy-py3-devel
BuildRequires: python3-module-Cython

%add_python3_req_skip macport mac_context hypothesis
%add_python3_req_skip wx.aui wx.glcanvas wx.grid wx.py.shell

%description
The Enable project provides two related multi-platform packages for
drawing GUI objects. The Enable package is a multi-platform object
drawing library built on top of Kiva. The core of Enable is a
container/component model for drawing and event notification. Kiva is a
multi-platform DisplayPDF vector drawing engine that supports multiple
output backends, including Windows, GTK, and Macintosh native windowing
systems, a variety of raster image formats, PDF, and Postscript.

%package tests
Summary: Tests for Enable project
Group: Development/Python3
Requires: %name = %EVR
%add_python3_req_skip hypothesis
%add_python3_req_skip etsdevtools.debug.memusage

%description tests
The Enable project provides two related multi-platform packages for
drawing GUI objects. The Enable package is a multi-platform object
drawing library built on top of Kiva. The core of Enable is a
container/component model for drawing and event notification. Kiva is a
multi-platform DisplayPDF vector drawing engine that supports multiple
output backends, including Windows, GTK, and Macintosh native windowing
systems, a variety of raster image formats, PDF, and Postscript.

This package contains tests for Enable project.

%if_disabled bootstrap
%package pickles
Summary: Pickles for Enable project
Group: Development/Python3

%description pickles
The Enable project provides two related multi-platform packages for
drawing GUI objects. The Enable package is a multi-platform object
drawing library built on top of Kiva. The core of Enable is a
container/component model for drawing and event notification. Kiva is a
multi-platform DisplayPDF vector drawing engine that supports multiple
output backends, including Windows, GTK, and Macintosh native windowing
systems, a variety of raster image formats, PDF, and Postscript.

This package contains pickles for Enable project.

%package doc
Summary: Documentation for Enable project
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name < %EVR

%description doc
The Enable project provides two related multi-platform packages for
drawing GUI objects. The Enable package is a multi-platform object
drawing library built on top of Kiva. The core of Enable is a
container/component model for drawing and event notification. Kiva is a
multi-platform DisplayPDF vector drawing engine that supports multiple
output backends, including Windows, GTK, and Macintosh native windowing
systems, a variety of raster image formats, PDF, and Postscript.

This package contains development documentation for Enable project.
%endif

%prep
%setup -n enable-%version
%patch -p1
%patch1 -p1

# remove python3-only backend
rm -rf enable/enable/vtk_backend

%if_disabled bootstrap
%prepare_sphinx .
%endif

%build
%add_optflags -fno-strict-aliasing

%python3_build

%if_disabled bootstrap
%generate_pickles docs/source docs/source %oname
sphinx-build -E -a -b html -c docs/source -d doctrees docs/source html
%endif

%install
%python3_install

rm -fR %buildroot%python3_sitelibdir/enthought/kiva/mac
rm -f $(find %buildroot%python3_sitelibdir -name '*mac*.py*')

# remove shebangs from files
find %buildroot%python3_sitelibdir -type f -name '*.py' -exec \
	sed -i -e '1!b' -e '/^\#\!\/usr\/bin\/env python$/d' '{}' +

%if_disabled bootstrap
install -d %buildroot%python_sitelibdir/enable
cp -fR pickle %buildroot%python_sitelibdir/enable/
%endif

%if_disabled bootstrap
%files pickles
%dir %python_sitelibdir/enable
%python_sitelibdir/enable/pickle

%files doc
%doc docs examples
%endif

%files
%doc image_LICENSE*.txt LICENSE.txt
%doc *.rst CHANGES.txt
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/test*
%exclude %python3_sitelibdir/*/*/test*
%exclude %python3_sitelibdir/*/example*
%exclude %python3_sitelibdir/*/*/tests
%exclude %python3_sitelibdir/*/*/*/tests

%files tests
%python3_sitelibdir/*/test*
%python3_sitelibdir/*/*/test*
%python3_sitelibdir/*/example*
%python3_sitelibdir/*/*/tests
%python3_sitelibdir/*/*/*/tests

%changelog
