%define oname clyde

%def_without docs

Name: python3-module-%oname
Version: 0.8.0
Release: alt1.git20141130.2.1
Summary: Command line interface designer
License: MIT
Group: Development/Python3
BuildArch: noarch
Url: https://pypi.python.org/pypi/clyde/

# https://github.com/clyde-hub/clyde.git
Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-coverage python3-module-jinja2-tests python3-module-nose
BuildRequires: python3(sugarbowl)
%if_with docs
BuildRequires: python3-module-html5lib python3-module-sphinx-settings python3(sphinx_rtd_theme)
%endif

%py3_provides %oname
%py3_requires sugarbowl jinja2

%description
Clyde is a command line interface designer.

%prep
%setup

%build
%python3_build_debug

%install
%python3_install

%if_with docs
export PYTHONPATH=$PWD
pushd docs
py3_sphinx-build -b html -d _build/doctrees . _build/html
popd
%endif

%check
python3 setup.py test

%files
%doc *.rst demo
%if_with docs
%doc docs/_build/html
%endif
%python3_sitelibdir/*

%changelog
