%define _unpackaged_files_terminate_build 1

%def_without static

Name: qalculate
Version: 3.19.0
Release: alt1

Summary: A very versatile desktop calculator
Group: Office
License: GPL-2.0+
Url: https://qalculate.github.io/

# https://github.com/Qalculate/libqalculate.git
Source: lib%name-%version.tar

BuildRequires: libcln-devel gcc-c++ glib2-devel libgmp-devel libstdc++-devel perl-XML-Parser pkgconfig zlib-devel intltool libtool libxml2-devel
BuildRequires: libcurl-devel libicu-devel libmpfr-devel doxygen

%description
Qalculate! is a modern multi-purpose desktop calculator for GNU/Linux.
It is small and simple to use but with much power and versatility
underneath. Features include customizable functions, units, arbitrary
precision, plotting.

%package -n lib%name
Summary: libqalculate libraries
Group: System/Libraries
Requires: %name-common = %EVR
Requires: /usr/bin/gnuplot

%description -n lib%name
Qalculate libraries.

%package -n lib%name-devel
Summary: libqalculate development package
Group: Development/C
Requires: lib%name = %EVR

%description -n lib%name-devel
The libqalculate package contains the header files needed for developing
applications that use libqalculate. Install libqalculate-devel if
you want to develop applications using libqalculate.

%if_enabled static
%package -n %libname-devel-static
Summary: libqalculate static library
Group: Development/C
Requires: lib%name-devel = %EVR

%description -n lib%name-devel-static
This package contains static version of libqalculate. Install
libqalculate-devel-static if you want to develop applications statically linked
with libqalculate.
%endif

%package common
Summary: qalculate common files
Group: Office

%description common
This package contains common files used by qalculate frontends.

%prep
%setup -q -n lib%name-%version

%build
%autoreconf

%configure \
	--enable-defs2doc

pushd docs/reference
doxygen
popd

%make_build

%install
%makeinstall_std

# remove non-packaged files
rm -f %buildroot%_libdir/*.la
%if_without static
rm -f %buildroot%_libdir/*.a
%endif

%find_lang --output=%name.lang lib%name

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_includedir/lib%name
%_libdir/*.so
%_libdir/pkgconfig/*
%_defaultdocdir/lib%name

%files
%_bindir/*
%_man1dir/*.1*

%files common -f %name.lang
%doc COPYING
%doc AUTHORS ChangeLog README README.md README.translate
%_datadir/qalculate

%if_with static
%files -n lib%name-devel-static
%_libdir/*.a
%endif

%changelog
