%define _unpackaged_files_terminate_build 1

%def_with ClangCodeModel
%define llvm_version 10.0

%add_findreq_skiplist  %_datadir/qtcreator/*
%add_findprov_skiplist %_datadir/qtcreator/*

Name:    qt-creator
Version: 4.13.3
Release: alt0.2.p9

Summary: Cross-platform IDE for Qt
License: GPL-3.0 with Qt-GPL-exception-1.0 and MIT and LGPL-2.0 and LGPL-2.1 and LGPL-3.0 and BSD-3-Clause and BSL-1.0 and ALT-Public-Domain
Group:   Development/Tools

Url:     http://qt-project.org/wiki/Category:Tools::QtCreator
Packager: Andrey Cherepanov <cas@altlinux.org>

Source:  %name-%version.tar
# VCS:   git://code.qt.io/qt-creator/qt-creator.git
Source1: qbs.tar
Source2: perfparser.tar

Patch0:  %name-%version-%release.patch
Patch1:  0001-Link-against-libclang-cpp.so.patch

Provides: qtcreator = %EVR
Obsoletes: qtcreator-clangcodemodel
Provides: qtcreator-clangcodemodel = %EVR

BuildRequires(pre): qt5-base-devel >= 5.9.0
BuildRequires(pre): rpm-build-python3
BuildRequires: gcc-c++
BuildRequires: qt5-designer >= 5.9.0
BuildRequires: qt5-script-devel >= 5.9.0
BuildRequires: qt5-declarative-devel >= 5.9.0
%ifnarch %e2k
# NB: there's rpm-macros-qt5-webengine out there
BuildRequires: qt5-webkit-devel >= 5.9.0
%endif
BuildRequires: qt5-x11extras-devel >= 5.9.0
BuildRequires: qt5-xmlpatterns-devel >= 5.9.0
BuildRequires: qt5-tools-devel >= 5.9.0
%if_with ClangCodeModel
BuildRequires: llvm%llvm_version-devel
BuildRequires: llvm%llvm_version-devel-static
BuildRequires: clang%llvm_version-devel
BuildRequires: clang%llvm_version-devel-static
BuildRequires: clang%llvm_version
BuildRequires: lld%llvm_version
%endif
BuildRequires: libsystemd-devel

Requires: %name-core = %EVR
# Add Qt5 build environment to build Qt project
Requires: qt5-base-devel
Requires: qt5-tools

%ifarch %e2k
# error: cpio archive too big - 4446M
%global __find_debuginfo_files %nil
%endif

%description
Qt Creator (previously known as Project Greenhouse) is a new, lightweight,
cross-platform integrated  development environment (IDE) designed to make
development with the Qt application framework even faster and easier.

This package contains IDE and Qt5 build environment.

%package core
Summary: Cross-platform IDE for Qt
Group:   Development/Tools
Requires: %name-data = %EVR
Provides: qbs = 1.14.0
Obsoletes: qbs < 1.14.0
Requires: qt5-quickcontrols
Requires: qt5-translations

%description core
Qt Creator (previously known as Project Greenhouse) is a new, lightweight,
cross-platform integrated  development environment (IDE) designed to make
development with the Qt application framework even faster and easier.

This is core part of IDE without Qt5 build environment.

%package doc
Summary: %name docs
Group: Documentation
BuildArch: noarch
Requires: %name

%description doc
Documentation for %name

%package data
Summary: Data files for %name
Group: Development/Tools
BuildArch: noarch
Requires: %name-core = %EVR

%description data
Data files for %name

%prep
%setup
# Unpack submodules content
tar xf %SOURCE1
tar xf %SOURCE2
sed -i 's,tools\/qdoc3,bin,' doc/doc.pri
#subst 's,share\/doc\/qtcreator,share\/qtcreator\/doc,' doc/doc.pri src/plugins/help/helpplugin.cpp
%patch0 -p1
%patch1 -p1
%ifarch %e2k
# strip UTF-8 BOM, lcc 1.23 won't ignore it yet
find src -type f -print0 -name '*.cpp' -o -name '*.h' |
	xargs -r0 sed -ri 's,^\xEF\xBB\xBF,,'
%endif
# Use Python3 for Python scripts
subst 's@#!.*python[23]\?@#!%__python3@' `find . -name \*.py` \
	src/shared/qbs/src/3rdparty/python/bin/dmgbuild \
	src/libs/qt-breakpad/qtbreakpadsymbols

%build
export QTDIR=%_qt5_prefix
export PATH="%{_qt5_bindir}:$PATH"
%ifarch %e2k
# fool sqlite into building with lcc
sed -i 's,^QMAKE_CFLAGS_WARN_ON.*$,& -D__INTEL_COMPILER,' src/libs/3rdparty/sqlite/sqlite.pri
%endif
%if_with ClangCodeModel
export LLVM_INSTALL_DIR="%_prefix"
%remove_optflags -frecord-gcc-switches
%endif

%qmake_qt5 -r IDE_LIBRARY_BASENAME=%_lib \
	CONFIG+="disable_external_rpath" \
	QMAKE_STRIP= \
	CONFIG+="journald" \
%if_with ClangCodeModel
	-spec linux-clang \
	QMAKE_LFLAGS+="-fuse-ld=lld" \
%endif
	%nil

%make_build
%make_build qch_docs

%install
%install_qt5 INSTALL_ROOT=%buildroot/%_prefix
%install_qt5 INSTALL_ROOT=%buildroot/%_prefix install_inst_qch_docs

# Remove Windows cdb debugger support to prevent unmet python2.7(cdbext)
rm -f %buildroot%_datadir/qtcreator/debugger/cdbbridge.py

# Make symlink to prevent package upgrade failure
rm -rf %buildroot%_datadir/qtcreator/qbs/share/qbs/examples/cocoa-application/CocoaApplication/en_US.lproj
ln -s en.lproj %buildroot%_datadir/qtcreator/qbs/share/qbs/examples/cocoa-application/CocoaApplication/en_US.lproj

%files

%files core
%doc README* LICENSE*
%_bindir/*
%_libdir/qtcreator
%dir %_libdir/qtcreator/plugins
%_prefix/libexec/qtcreator
%_iconsdir/hicolor/*/apps/QtProject-qtcreator.png
%_desktopdir/*.desktop
%_datadir/metainfo/*.xml

%files doc
%_defaultdocdir/qtcreator

%files data
%dir %_datadir/qtcreator
%_datadir/qtcreator/*

%changelog
