%global srcname qutebrowser

Name: %srcname
Version: 1.6.1
Release: alt1
Summary: A keyboard-driven, vim-like browser based on PyQt5 and QtWebEngine
License: GPLv3
Group: Networking/WWW
Packager: Ilya Mashkin <oddity@altlinux.ru>
Url: http://www.qutebrowser.org
Source0: https://github.com/%srcname/%srcname/releases/download/v%version/%srcname-%version.tar.gz
BuildArch: noarch
BuildRequires: python3-devel
BuildRequires: asciidoc asciidoc-a2x
BuildRequires: desktop-file-utils python3-module-setuptools
#Requires: qt5-qtbase
#Requires: qt5-qtdeclarative
#Requires: python3-module-setuptools
#Requires: python3-qt5
#Requires: python3-qt5-webengine
#Requires: python3-jinja2
#Requires: python3-pygments
#Requires: python3-PyYAML
#Requires: python3-pyPEG2
#Requires: python3-attrs
#Requires: qt5-qtwebengine qt5-qtwebkit python3-qt5-webkit python3-cssutils
Provides: python3(qutebrowser.extensions)

%description
qutebrowser is a keyboard-focused browser with a minimal GUI. It's based on
Python, PyQt5 and QtWebEngine and free software, licensed under the GPL.
It was inspired by other browsers/addons like dwb and Vimperator/Pentadactyl.

%prep
%setup -n %srcname-%version

%build
# Compile the man page
a2x -f manpage doc/qutebrowser.1.asciidoc

# Find all *.py files and if their first line is exactly '#!/usr/bin/env python3'
# then replace it with '#!/usr/bin/python3' (if it's the 1st line).
find . -type f -iname "*.py" -exec sed -i '1s_^#!/usr/bin/env python3$_#!/usr/bin/python3_' {} +

%python3_build

%install
%python3_install

# install .desktop file
desktop-file-install \
	--add-category="Network" \
	--delete-original \
	--dir=%buildroot%_datadir/applications \
	misc/%srcname.desktop

# Install man page
install -Dm644 doc/%srcname.1 -t %buildroot%_mandir/man1

# Install icons
install -Dm644 icons/qutebrowser.svg \
	-t "%buildroot%_datadir/icons/hicolor/scalable/apps"
for i in 16 24 32 48 64 128 256 512; do
	install -Dm644 "icons/qutebrowser-${i}x${i}.png" \
		"%buildroot%_datadir/icons/hicolor/${i}x${i}/apps/qutebrowser.png"
done

# Set __main__.py as executable
chmod 755 %buildroot%python3_sitelibdir/%srcname/__main__.py

# Remove zero-length files:
# https://fedoraproject.org/wiki/Packaging_tricks#Zero_length_files
find %buildroot -size 0 -delete

%files
#license LICENSE
%doc README.asciidoc doc/changelog.asciidoc qutebrowser/html/doc
%python3_sitelibdir/%srcname-%version-py?.?.egg-info
%python3_sitelibdir/%srcname
%_bindir/%srcname
%_datadir/applications/%srcname.desktop
%_mandir/man1/%srcname.1*
%_datadir/icons/hicolor/scalable/apps/%srcname.svg
%_datadir/icons/hicolor/16x16/apps/%srcname.png
%_datadir/icons/hicolor/24x24/apps/%srcname.png
%_datadir/icons/hicolor/32x32/apps/%srcname.png
%_datadir/icons/hicolor/48x48/apps/%srcname.png
%_datadir/icons/hicolor/64x64/apps/%srcname.png
%_datadir/icons/hicolor/128x128/apps/%srcname.png
%_datadir/icons/hicolor/256x256/apps/%srcname.png
%_datadir/icons/hicolor/512x512/apps/%srcname.png

%changelog
