Name: refind
Version: 0.11.4
Release: alt1

Summary: EFI boot manager software
License: GPLv3
Group: System/Base

Url: http://www.rodsbooks.com/refind/
# https://git.code.sf.net/p/refind/code
Source: %name-%version.tar 
Source1: altlinux_altinst.png
Source2: altlinux_live.png
Source3: altlinux_rescue.png
Source4: os_altlinux.png

Patch1: refind-0.11.3-alt-split-cfg.patch

BuildRequires(pre): rpm-macros-uefi
BuildRequires: gnu-efi >= 3.0.6-alt1
BuildRequires: unzip
BuildRequires: pesign >= 0.109-alt4
Requires: efibootmgr
Obsoletes: refind-signed

ExclusiveArch: x86_64

%define refind_lib %_efi_bindir
%define refind_data %_datadir/%name

%description
A graphical boot manager for EFI- and UEFI-based computers, such as all
Intel-based Macs and recent (most 2011 and later) PCs. rEFInd presents a
boot menu showing all the EFI boot loaders on the EFI-accessible
partitions, and optionally BIOS-bootable partitions on Macs. EFI-compatbile
OSes, including Linux, provide boot loaders that rEFInd can detect and
launch. rEFInd can launch Linux EFI boot loaders such as ELILO, GRUB
Legacy, GRUB 2, and 3.3.0 and later kernels with EFI stub support. EFI
filesystem drivers for ext2/3/4fs, ReiserFS, HFS+, and ISO-9660 enable
rEFInd to read boot loaders from these filesystems, too. rEFInd's ability
to detect boot loaders at runtime makes it very easy to use, particularly
when paired with Linux kernels that provide EFI stub support.

Please note that the official build is signed; this shouldn't
intervene in any way but rather provides means to cope with
UEFI SecureBoot (better described as Restricted Boot) firmware
when one can't disable it easily, doesn't want to, or needs not to.

%prep
%setup
%patch1 -p1

%build
mkdir -p ../ia32_build
cp -r ./* ../ia32_build
make gnuefi EFICRT0=%_libdir GNUEFILIB=%_libdir
make fs_gnuefi EFICRT0=%_libdir GNUEFILIB=%_libdir

pushd ../ia32_build
make gnuefi EFICRT0=/usr/lib GNUEFILIB=/usr/lib ARCH=ia32
make fs_gnuefi EFICRT0=/usr/lib GNUEFILIB=/usr/lib ARCH=ia32
popd

%install
mkdir -p %buildroot{%refind_lib{,/drivers_%_efi_arch,/drivers_ia32},%refind_data}

install -pm644 refind/refind*.efi %buildroot%refind_lib/
cp -a drivers_%_efi_arch/*.efi %buildroot%refind_lib/drivers_%_efi_arch/
install -pm644 ../ia32_build/refind/refind*.efi %buildroot%refind_lib/
cp -a ../ia32_build/drivers_ia32/*.efi %buildroot%refind_lib/drivers_ia32/

cp -a icons/ %buildroot%refind_data/
install -pDm644 %SOURCE1 %buildroot%refind_data/icons/altlinux/altinst.png
install -pDm644 %SOURCE2 %buildroot%refind_data/icons/altlinux/live.png
install -pDm644 %SOURCE3 %buildroot%refind_data/icons/altlinux/rescue.png
install -pDm644 %SOURCE4 %buildroot%refind_data/icons/os_altlinux.png

%files
%doc docs/Styles docs/refind
%doc NEWS.txt COPYING.txt LICENSE.txt README.txt CREDITS.txt
%refind_lib
%refind_data

%changelog
