# vim: set ft=spec: -*- rpm-spec -*-

%define _name licenses

Name: rpm-build-%_name
Version: 2.0.5
Release: alt2

Summary: RPM macros for well-known licenses
# We can't use our own macros...
License: GPLv2
Group: Development/Other
Url: http://www.altlinux.org/License

Source: %name-%version.tar

Packager: Aleksey Avdeev <solo@altlinux.ru>
BuildArch: noarch

Requires: common-licenses

%description
This package contains RPM macros for license names commonly used in
Open Source software. Use these macros in License tags of your specfiles.

%prep
%setup -n %name-%version
ln -sf %_licensedir/GPL-2 COPYING

%install
cat <<__EOF__ >%_name.rpmmacros
%%gpl2only GPLv2
%%gpl2plus GPLv2+
%%gpl3only GPLv3
%%gpl3plus GPLv3+
%%lgpl2only LGPLv2
%%lgpl21only LGPLv2.1
%%lgpl2plus LGPLv2+
%%lgpl21plus LGPLv2.1+
%%lgpl3only LGPLv3
%%lgpl3plus LGPLv3+
%%bsd_orig BSD (original)
%%bsd BSD (revised)
%%bsdstyle BSD-style
%%mit MIT/X Consortium
%%mpl MPL
%%w3cl W3C
%%asl Apache
%%jpackage_license JPackage
%%sendmail_license Sendmail
%%artistic_license Artistic
%%artistic_license_v2 Artistic 2.0
%%perl_license Perl (GPL or Artistic)
%%fdl FDL
%%gfdl GFDL
%%lppl LPPL
%%qpl1 QPLv1.0
%%ccbysa30 CC-BY-SA-3.0
%%ccby30 CC-BY-3.0
%%ccbysa25 CC-BY-SA-2.5
%%ccby25 CC-BY-2.5
%%epl Erlang Public License
%%pubdomain Public domain
%%distributable Distributable, non-free
%%gagpl3only GAGPLv3
%%gagpl3plus GAGPLv3+

# Not sure whether these ones should exist at all. Too clumsy names and vague
# semantics.
%%gpllgpl2only \
%{warning Hopefully you have read the README section about %%gpllgpl* macros.}\
GPLv2, LGPLv2
%%gpllgpl2plus \
%{warning Hopefully you have read the README section about %%gpllgpl* macros.}\
GPLv2+, LGPLv2+
%%gpllgpl3only \
%{warning Hopefully you have read the README section about %%gpllgpl* macros.}\
GPLv3, LGPLv3
%%gpllgpl3plus \
%{warning Hopefully you have read the README section about %%gpllgpl* macros.}\
GPLv3+, LGPLv3+
__EOF__
install -pD -m644 %_name.rpmmacros %buildroot%_rpmmacrosdir/%_name

%files
%_rpmmacrosdir/%_name
%doc README
%doc --no-dereference COPYING

%changelog
