%define pkgname mocha

Name: ruby-%pkgname
Version: 1.7.0
Release: alt1

Summary: Library for mocking and stubbing in Ruby
Group: Development/Ruby
License: MIT/Ruby
Url: http://rubyforge.org/projects/mocha/

Packager: Ruby Maintainers Team <ruby@packages.altlinux.org>

BuildArch: noarch

Source: %pkgname-%version.tar

BuildRequires(pre): rpm-build-ruby 
BuildRequires: ruby-tool-rdoc ruby-tool-setup ruby-test-unit
BuildRequires: ruby-metaclass

%description
Mocha is a library for mocking and stubbing in Ruby using a syntax
like that of JMock. Mocha provides a unified, simple and readable
syntax for both traditional and partial mocking.

%package doc
Summary: Documentation files for %name
Group: Documentation

%description doc
Documentation files for %name

%prep
%setup -n %pkgname-%version
%update_setup_rb

%build
%ruby_config
%ruby_build

%install
%ruby_install
%rdoc lib/

%check
%ruby_test_unit -Ilib:test test/unit/*_test.rb test/unit/*/*_test.rb

%files
%doc *.md
%ruby_sitelibdir/*
%rubygem_specdir/*

%files doc
%ruby_ri_sitedir/Mocha*

%changelog
