%define  pkgname sequel

Name:          ruby-%pkgname
Version:       5.19.0
Release:       alt1
Summary:       Sequel is a simple, flexible, and powerful SQL database access toolkit for Ruby
License:       MIT
Group:         Development/Ruby
Url:           http://sequel.jeremyevans.net
# VCS:         https://github.com/jeremyevans/sequel.git
BuildArch:     noarch
Packager:      Ruby Maintainers Team <ruby@packages.altlinux.org>
Source:        %name-%version.tar

BuildRequires(pre): rpm-build-ruby

%description
Sequel is a simple, flexible, and powerful SQL database access toolkit for Ruby.

- Sequel provides thread safety, connection pooling
  and a concise DSL for constructing SQL queries and table schemas.
- Sequel includes a comprehensive ORM layer for mapping records
  to Ruby objects and handling associated records.
- Sequel supports advanced database features such as prepared statements,
  bound variables, savepoints, two-phase commit, transaction isolation,
  master/slave configurations, and database sharding.
- Sequel currently has adapters for ADO, Amalgalite, IBM_DB, JDBC, MySQL,
  Mysql2, ODBC, Oracle, PostgreSQL, SQLAnywhere, SQLite3, and TinyTDS.

%package       doc
Summary:       Documentation files for %name
Group:         Development/Documentation
BuildArch:     noarch

%description   doc
Documentation files for %name

%prep
%setup

%build
%gem_build --join=lib:bin

%install
%gem_install

%check
%gem_test

%files
%doc README*
%_bindir/*
%ruby_gemspec
%ruby_gemlibdir

%files         doc
%ruby_gemdocdir

%changelog
