%def_without lightning
%def_without system_mozldap
%def_without system_nss
%define clang_version 12.0

%define sm_prefix %_libdir/%name
%define sm_datadir %_datadir/%name
%define sm_version %name-%version
%define sm_arch_extensionsdir %sm_prefix/extensions
%define sm_noarch_extensionsdir %sm_datadir/extensions
%define sm_cid \{92650c4d-4b8e-4d2a-b7eb-24ecf4f6b63a}
%define sm_idldir %_datadir/idl/%name
%define sm_includedir %_includedir/%name
%define sm_develdir %sm_prefix-devel
%ifndef build_parallel_jobs
%define build_parallel_jobs 32
%endif
%define beta_suffix %nil
%define cid langpack-ru@seamonkey.mozilla.org
%define ciddir %sm_prefix/extensions/%cid

Name: seamonkey
Version: 2.53.14
Release: alt1
Epoch: 1
Summary: Web browser and mail reader
License: MPL-2.0
Group: Networking/WWW
Url: http://www.mozilla.org/projects/seamonkey/

Packager: Andrey Cherepanov <cas@altlinux.org>

# TODO: build failed on aarch64 and ppc64le
ExclusiveArch: %ix86 x86_64

Source0: %name-%version%beta_suffix.source.tar.xz
Source2: mozilla-searchplugins.tar
Source3: seamonkey-alt-browser.desktop
Source4: seamonkey-alt-mail.desktop
Source5: seamonkey-prefs.js
Source7: seamonkey-mozconfig
Source8: rpm-build.tar
Source9: cbindgen-vendor.tar
# Get from http://ftp.mozilla.org/pub/seamonkey/releases/$ver/langpack/seamonkey-$ver.ru.langpack.xpi
Source10: seamonkey-%{version}.ru.langpack.xpi
Source11: seamonkey-ru.watch

Patch0: seamonkey-fix-installdirs.patch
Patch1: seamonkey-alt-machOS-fix.patch
%if_with system_mozldap
Patch5: thunderbird-with-system-mozldap.patch
%endif
Patch8: seamonkey-2.26-enable-addons.patch
Patch9: mozilla-js-makefile.patch
Patch10: firefox-32-baseline-disable.patch
Patch11: seamonkey-2.53.2-alt-ppc64le-disable-broken-getProcessorLineSize-code.patch
Patch12: seamonkey-2.53.2-alt-ppc64le-fix-clang-error-invalid-memory-operand.patch
Patch13: seamonkey-packed_simd-for-rust-1.56.patch
Patch14: seamonkey-alt-disable-elfhack.patch
Patch120: 0020-MOZILLA-1666567-land-NSS-8ebee3cec9cf-UPGRADE_NSS_RE.patch
Patch121: 0021-MOZILLA-1666567-land-NSS-8fdbec414ce2-UPGRADE_NSS_RE.patch
Patch122: 0022-MOZILLA-1666567-land-NSS-NSS_3_58_BETA1-UPGRADE_NSS_.patch
Patch124: 0024-MOZILLA-1605273-only-run-CRLite-on-certificates-with.patch

Requires(pre,postun): urw-fonts

#Obsoletes
Obsoletes: seamonkey-dom-inspector
Provides: seamonkey-dom-inspector
Obsoletes: seamonkey-enigmail
Provides: seamonkey-enigmail
Obsoletes: seamonkey-irc
Provides: seamonkey-irc
Obsoletes: seamonkey-js-debugger
Provides: seamonkey-js-debugger
Obsoletes: seamonkey-mail
Provides: seamonkey-mail
Obsoletes: seamonkey-plugins-common
Provides: seamonkey-plugins-common
Obsoletes: seamonkey-psm
Provides: seamonkey-psm
Obsoletes: seamonkey-spellchecker
Provides: seamonkey-spellchecker
Obsoletes: seamonkey-ru < %EVR
Provides: seamonkey-ru = %EVR

BuildRequires(pre): rpm-macros-alternatives
BuildRequires(pre): browser-plugins-npapi-devel

# Automatically added by buildreq on Sun Jul 16 2006
%if_with system_mozldap
BuildPreReq: mozldap-devel
%endif
BuildRequires: gcc-c++
BuildRequires: clang%clang_version
BuildRequires: clang%clang_version-devel
BuildRequires: llvm%clang_version-devel
BuildRequires: lld%clang_version-devel
BuildRequires: libdnet-devel libgtk+2-devel libgtk+3-devel libIDL-devel wget libarchive-devel libpixman-devel
BuildRequires: libjpeg-devel libpng-devel libXinerama-devel libXext-devel
BuildRequires: libXp-devel libXt-devel makedepend net-tools unzip libalsa-devel yasm libwireless-devel
BuildRequires: xorg-cf-files zip libXft-devel
#BuildRequires: libvpx-devel
BuildRequires: desktop-file-utils libcurl-devel libhunspell-devel libsqlite3-devel
BuildRequires: autoconf_2.13 chrpath alternatives libGL-devel
BuildRequires: libstartup-notification-devel libfreetype-devel fontconfig-devel libnotify-devel
BuildRequires: libffi-devel libgio-devel
BuildRequires: gst-plugins1.0-devel
BuildRequires: libpulseaudio-devel
BuildRequires: libXcomposite-devel
BuildRequires: libXdamage-devel
BuildRequires: libGConf-devel
BuildRequires: libevent-devel
BuildRequires: libproxy-devel
BuildRequires: libdbus-devel
BuildRequires: libdbus-glib-devel
BuildRequires: libXcursor-devel
BuildRequires: libXi-devel
BuildRequires: nasm

# Rust requires
BuildRequires: rust
BuildRequires: rust-cargo
BuildRequires: /proc

# seamonkey-ru
BuildRequires: unzip
BuildRequires: hunspell-ru

# Mozilla requires
BuildRequires: libnspr-devel       >= 4.9.2-alt1
%if_with system_nss
BuildRequires: libnss-devel        >= 3.15.1-alt1
BuildRequires: libnss-devel-static >= 3.15.1-alt1
%endif

# Python requires
BuildRequires: python2-base
BuildRequires: python-module-distribute
BuildRequires: python-modules-compiler
BuildRequires: python-modules-logging
BuildRequires: python-modules-sqlite3
BuildRequires: python-modules-json

BuildRequires: python3-base
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-pip
BuildRequires: python3-modules-sqlite3

Requires: hunspell-ru

%set_autoconf_version 2.13
%add_findprov_lib_path %sm_prefix

%description
SeaMonkey is an open-source web browser, designed for standards
compliance, performance and portability.

%if_with lightning
%package lightning
%define lightning_ciddir %sm_arch_extensionsdir/\{e2fda1a4-762b-4020-b5ad-a41df1933103\}
Summary: An integrated calendar for Seamonkey
Group: Office
Url: http://www.mozilla.org/projects/calendar/lightning/
Requires: %name = %epoch:%version-%release

%description lightning
An integrated calendar for Seamonkey.
%endif

%package devel
Summary: Seamonkey development kit.
Group: Development/C++
Requires: %name = %epoch:%version-%release

Requires: python-base
AutoReq: yes, nopython

%description devel
Seamonkey development kit.

%package -n rpm-build-seamonkey
Summary:  RPM environment to rebuild seamonkey packages
Group: Development/Other
BuildArch: noarch

Requires: mozilla-common-devel
Requires: rpm-build-mozilla.org
Requires: rpm-macros-seamonkey = %EVR

%description -n rpm-build-seamonkey
These helper macros provide possibility to rebuild
seamonkey packages by some Alt Linux Team Policy compatible way.


%package -n rpm-macros-seamonkey
Summary: RPM helper macros to rebuild seamonkey packages
Group: Development/Other
BuildArch: noarch
Conflicts: rpm-build-seamonkey <= 2.53.12-alt1

%description -n rpm-macros-seamonkey
Install this package if you want to create RPM packages for seamonkey.

%prep
%setup -n %name-%version%beta_suffix

#patch0 -p1
%patch1 -p1
%if_with system_mozldap
%patch5 -p1 -b .mozldap
%endif
#%%patch8 -p2
#patch9 -p2

# https://bugzilla.altlinux.org/30322
%ifarch %{ix86}
%patch10 -p2
%endif
%patch11 -p2
%patch12 -p2
#patch13 -p1
%patch14 -p1
%if_with system_nss
%patch120 -p2
%patch121 -p2
%patch122 -p2
%patch124 -p1
%endif

### Copying .mozconfig to build directory
cp -f %SOURCE7 .mozconfig

%if_with lightning
echo 'ac_add_options --enable-calendar' >> .mozconfig
%endif

mkdir -p -- my_rust_vendor
tar --strip-components=1 -C my_rust_vendor --overwrite -xf %SOURCE9

mkdir -p -- .cargo
cat > .cargo/config <<EOF
[source.crates-io]
replace-with = "vendored-sources"

[source.vendored-sources]
directory = "$PWD/my_rust_vendor"
EOF

%build
%add_optflags %optflags_shared
%add_findprov_lib_path %sm_prefix

env CARGO_HOME="$PWD/.cargo" \
        cargo install cbindgen

# Add fake RPATH
rpath="/$(printf %%s '%sm_prefix' |tr '[:print:]' '_')"
export LDFLAGS="$LDFLAGS -Wl,-rpath,$rpath"
export LIBIDL_CONFIG=/usr/bin/libIDL-config-2

export MOZ_BUILD_APP=comm/suite

%ifarch x86_64
export CFLAGS="$CFLAGS -DHAVE_USR_LIB64_DIR=1"
%endif

%ifarch %{arm} %{ix86}
export RUSTFLAGS="-Cdebuginfo=0"
export LLVM_PARALLEL_LINK_JOBS=1
# See https://lwn.net/Articles/797303/ for linker flags
# For bfd on i586
export CXXFLAGS="$CXXFLAGS -Wl,--no-keep-memory -Wl,--reduce-memory-overheads -Wl,--hash-size=1021"
# For gold on i586
#export CXXFLAGS="$CXXFLAGS -Wl,--no-threads -Wl,--no-keep-files-mapped -Wl,--no-map-whole-files -Wl,--no-mmap-output-file -Wl,--stats"
%endif

export CC="clang"
export CXX="clang++"
export CC="clang"
export CXX="clang++"
export AR="llvm-ar"
export NM="llvm-nm"
export RANLIB="llvm-ranlib"
export LLVM_PROFDATA="llvm-profdata"

export PREFIX="%_prefix"
export LIBDIR="%_libdir"
export SHELL="/bin/bash"
export srcdir="$PWD"
export MOZILLA_SRCDIR="$srcdir"
export SHELL=/bin/sh
export MOZILLA_OBJDIR="$PWD"
export CBINDGEN_BINDIR=`pwd`/.cargo/bin
export PATH="$CBINDGEN_BINDIR:$PATH"

# Do not use desktop notify during build process
export MOZ_NOSPAM=1

# Don't throw "old profile" dialog box
export MOZ_ALLOW_DOWNGRADE=1

export NPROCS=%build_parallel_jobs
# Decrease NPROCS prevents oomkill terror on x86_64
%ifarch x86_64
export NPROCS=16
%endif
# Build for i586 in one thread
%ifarch %ix86
export NPROCS=1
%endif

#./mach python --exec-file /dev/null
./mach configure
./mach build -j $NPROCS
./mach buildsymbols

%install
export SHELL=/bin/sh
dir="$PWD/objdir"

mkdir -p \
	%buildroot/%_bindir \
	%buildroot/%sm_prefix/plugins \
	%buildroot/%sm_arch_extensionsdir \
	%buildroot/%sm_noarch_extensionsdir \
	%buildroot/%_datadir/applications \
	#

%makeinstall -C objdir \
	idldir=%buildroot/%sm_idldir \
	includedir=%buildroot/%sm_includedir \
	mozappdir=%buildroot/%sm_prefix \
	#

ln -sf -- $(relative "%sm_noarch_extensionsdir" "%sm_prefix/") \
    %buildroot/%sm_prefix/extensions-noarch

(set +x
    for f in %buildroot/%sm_develdir/*; do
	[ -L "$f" ] || continue

	t="$(readlink "$f")"
	r="$(relative "${t#%buildroot}" "${f#%buildroot}")"

	ln -vnsf -- "$r" "$f"
    done
)

(set +x
    rm -vrf -- %buildroot/%sm_prefix/dictionaries/*
    for suf in aff dic; do
	t="$(relative %_datadir/myspell/en_US.$suf %sm_prefix/dictionaries/)"
	ln -vs "$t" %buildroot/%sm_prefix/dictionaries/en-US.$suf
    done
)

rm -rf -- \
	%buildroot/%_bindir/seamonkey \
	%buildroot/%sm_prefix/js \
	%buildroot/%sm_prefix/regxpcom \
	%buildroot/%sm_prefix/xpcshell \
	%buildroot/%sm_prefix/xpidl \
	%buildroot/%sm_prefix/xpt_dump \
	%buildroot/%sm_prefix/xpt_link \
	%buildroot/%sm_prefix/nsinstall \
	%buildroot/%sm_prefix/removed-files \
	%buildroot/%sm_prefix/seamonkey \
	%buildroot/%sm_prefix/run-mozilla.sh \
	%buildroot/%sm_prefix/README.txt \
	#

dir="$PWD/objdir"

###From Lightning
%if_with lightning
mkdir -p %buildroot/%lightning_ciddir
unzip -q -u -d %buildroot/%lightning_ciddir -- \
    $dir/dist/xpi-stage/lightning*.xpi

rm -f -- %buildroot/%lightning_ciddir/application.ini
%endif

# rpm-build-seamonkey files
mkdir -p %buildroot/%_rpmmacrosdir
tar -xf %SOURCE8
cp -a rpm-build/rpm.macros.seamonkey %buildroot/%_rpmmacrosdir/%name

# install altlinux-specific configuration
install -D -m 644 %SOURCE5 %buildroot/%sm_prefix/defaults/preferences/all-altlinux.js

# install icons
test -e comm/suite/branding/seamonkey/default32.png || cp comm/suite/branding/seamonkey/default{,32}.png
for s in 16 32 48 64 128; do
	install -Dpm0644 comm/suite/branding/seamonkey/default${s}.png %buildroot%_iconsdir/hicolor/${s}x${s}/apps/%name.png
done

# install search plugins
tar -C %buildroot%sm_prefix -xf %SOURCE2

# install browser menu file
install -D -m 644 %SOURCE3 %buildroot%_datadir/applications/seamonkey-alt-browser.desktop
# install mail menu file
install -D -m 644 %SOURCE4 %buildroot%_datadir/applications/seamonkey-alt-mail.desktop

# main startup script
cat>%buildroot/%_bindir/seamonkey<<-EOF
#!/bin/sh -e
    export MOZ_APP_LAUNCHER="\${MOZ_APP_LAUNCHER:-\$0}"
    export MOZ_PLUGIN_PATH="%browser_plugins_path\${MOZ_PLUGIN_PATH:+:\$MOZ_PLUGIN_PATH}"
    export NSS_SSL_ENABLE_RENEGOTIATION=1
    %sm_prefix/seamonkey-bin \${1:+"\$@"}
EOF


chmod 755 %buildroot/%_bindir/seamonkey

# Add alternatives
mkdir -p %buildroot%_altdir
printf '%_bindir/xbrowser\t%_bindir/%name\t100\n' > %buildroot%_altdir/%name

# Add real RPATH
(set +x
    rpath="/$(printf %%s '%sm_prefix' |tr '[:print:]' '_')"

    find \
	%buildroot/%sm_prefix \
	%buildroot/%sm_develdir \
	%buildroot/%sm_arch_extensionsdir \
    -type f |
    while read f; do
	t="$(readlink -ev "$f")"

	file "$t" | fgrep -qs ELF || continue

	if chrpath -l "$t" | fgrep -qs "RPATH=$rpath"; then
	chrpath -r "%sm_prefix" "$t"
	fi
    done
)

# Install langpack
mkdir -p %buildroot/%ciddir/dictionaries
unzip %SOURCE10 -d %buildroot/%ciddir
ln -s %_datadir/myspell/ru_RU.aff %buildroot/%ciddir/dictionaries/ru.aff
ln -s %_datadir/myspell/ru_RU.dic %buildroot/%ciddir/dictionaries/ru.dic

%files
%dir %sm_datadir
%ciddir
%_altdir/%name
%_bindir/%name
%_datadir/applications/*.desktop
%sm_prefix
%sm_noarch_extensionsdir
%_iconsdir/hicolor/*/apps/%name.png
%if_with lightning
%exclude %lightning_ciddir
%endif

%if_with lightning
%files lightning
%lightning_ciddir
%endif

%files -n rpm-build-seamonkey
%files -n rpm-macros-seamonkey
%_rpmmacrosdir/%name


%changelog
