Name: sevents
Version: 1.2
Release: alt7.r69

Summary: System of Events programming with random factor
Summary(ru_RU.UTF8): Система событийного программирования с фактором случайности
License: GPL
Group: Education

Url: https://sourceforge.net/projects/sevents
Source: %name-%version.tar.xz
Patch: sevents-distribution.patch
Packager: Rinat Bikov <becase@altlinux.org>

BuildRequires(pre): /proc rpm-build-java
BuildRequires(pre): java-devel-default
BuildRequires(pre): ant ant-junit ant-nodeps junit

Requires: %name-main %name-libloader

%description
SEvents is a System of Event programming with random factor 
designed to accept script file and execute it with using extra 
modules. One module - one object, who relate on changing of some variables.
It can change variables values, manages events activity and draw himself,
using standart interface.

%description -l ru_RU.UTF8
SEvents - система событийного программирования с фактором случайности.
Сценарий для системы пишется на событийном языке, в котором возможно определять
переменные и константы, а также события с обработчиками. Условие выполнения
события может быть любым, включая проверку переменных/констант и проверку
относительно других событий. В этой системе объектами являются динамические
библиотеки (so, dll), которые могут реагировать на изменения системы и
изменять её состояние.

%package -n %name-main
Summary: Main SEvents cross-platform program
Summary(ru_RU.UTF8): Главная, кросс-платфоменная часть программы SEvents
Group: Education
Requires: java >= 1.6
BuildArch: noarch

%description -n %name-main
Main part of SEvents

%description -n %name-main -l ru_RU.UTF8
Основная часть системы событийного программирования SEvents, написанная на Java.

%package -n %name-libloader
Summary: Loader of plugins for SEvents
Summary(ru_RU.UTF8): Загрузчик плагинов для SEvents
Group: Education

%description -n %name-libloader
Loader of plugins for SEvents. Plugins manager.

%description -n %name-libloader -l ru_RU.UTF8
Загрузчик плагинов для SEvents. Управляет загрузкой плагинов и предоставляет
интерфейс взаимодействия плагинов с системой.

%prep
%setup -q
%patch -p1

%build
mkdir bin
mkdir lib
cd src/
./makemodule.sh
./makemodule.sh 1
./makemodule.sh 2
./makemodule.sh 3
./makemodule.sh 4
cd ..
%ant -Dant.build.javac.source=1.6 -Dant.build.javac.target=1.6 jar
cd src/libloader/
%make
cd ../..

%install
mkdir -p %buildroot/
install -pD -m 644 ./dist/%name.jar  %buildroot/%_javadir/%name-%version.jar
install -pD -m 755 sevents %buildroot/%_bindir/sevents
install -pD -m 755 ./src/libloader/libseventsloader %buildroot/%_bindir/libseventsloader
install -pD -m 644 ./src/libloader/libseventsloader.so.%{version} %buildroot/%_libdir/libseventsloader.so.%{version}
ln -s -f %_javadir/%name-%version.jar %buildroot/%_javadir/%name.jar

%files

%files -n %name-main
%doc resources/BNF resources/readme-eng.txt resources/readme-rus.txt
%_javadir/*
%_bindir/sevents

%files -n %name-libloader
%_libdir/libseventsloader.so*
%_bindir/libseventsloader

%changelog
