# TODO: build external, json11 separately

# other variant: Debug
%define buildmode Release

%define ffmpeg_version 3.4
%def_without ffmpeg_static

Name: telegram-desktop
Version: 2.3.0
Release: alt1

Summary: Telegram Desktop messaging app

License: GPLv3 with OpenSSL exception
Group: Networking/Instant messaging
Url: https://telegram.org/

# Source-url: https://github.com/telegramdesktop/tdesktop/releases/download/v%version/tdesktop-%version-full.tar.gz
Source: %name-%version.tar

# Check https://github.com/EasyCoding/tgbuild for patches

BuildRequires(pre): rpm-macros-qt5 rpm-macros-cmake
#BuildRequires(pre): rpm-macros-kde-common-devel

BuildRequires(pre): rpm-build-compat >= 2.1.5
BuildRequires(pre): rpm-build-intro >= 2.1.5

# use no more than system_memory/3000 build procs (see https://bugzilla.altlinux.org/show_bug.cgi?id=35112)
%_tune_parallel_build_by_procsize 3000

# minimalize memory using
%ifarch %ix86 armh
%define optflags_debug -g0
%endif

BuildRequires: gcc-c++ libstdc++-devel python3

# cmake 3.16 as in CMakeLists.txt
BuildRequires: cmake >= 3.16

BuildRequires: qt5-base-devel libqt5-core libqt5-network libqt5-gui qt5-imageformats qt5-wayland-devel
# needs for smiles and emojicons
Requires: qt5-imageformats

# run around https://bugzilla.altlinux.org/show_bug.cgi?id=34665
Requires: libqt5-core >= %_qt5_version

# for -lQt5PlatformSupport
BuildRequires: qt5-base-devel-static

BuildRequires: libenchant2-devel
BuildRequires: libhunspell-devel

# for autoupdater (included ever if disabled)
# TODO:
BuildRequires: liblzma-devel

# for SourceFiles/mtproto/connection.cpp
BuildRequires: libzip-devel

BuildRequires: zlib-devel >= 1.2.8
BuildRequires: libxxhash-devel
BuildRequires: liblz4-devel

BuildRequires: libminizip-devel libpcre-devel libexpat-devel libssl-devel bison
#BuildRequires: libxkbcommon-devel libxkbcommon-x11-devel
#BuildRequires: libXi-devel libSM-devel libICE-devel libdbus-devel libXfixes-devel
# TODO:
BuildRequires: libX11-devel

# GTK 3.0 integration
BuildRequires: libgtk+3-devel libappindicator-gtk3-devel
# TODO:
# libdee-devel

BuildRequires: libopenal-devel >= 1.17.2
# libportaudio2-devel libxcb-devel 
# used by qt imageformats: libwebp-devel
BuildRequires: libva-devel libdrm-devel

BuildRequires: libtgvoip-devel >= 2.4.4-alt5
BuildRequires: libopus-devel

# uses forked version, tag e0ea6af518345c4a46195c4951e023e621a9eb8f
BuildRequires: librlottie-devel >= 0.1.1
BuildRequires: libqrcodegen-cpp-devel

# C++ sugar
BuildRequires: libmicrosoft-gsl-devel >= 1:3.0.1
BuildRequires: libvariant-devel
BuildRequires: libexpected-devel
BuildRequires: librange-v3-devel >= 0.10.0

BuildRequires: libdbusmenu-qt5-devel

# need for /usr/lib64/cmake/Qt5XkbCommonSupport/Qt5XkbCommonSupportConfig.cmake
BuildRequires: libxkbcommon-devel

# FIXME: libva need only for linking, extra deps?

Provides: tdesktop = %version-%release
Obsoletes: tdesktop

%if_with ffmpeg_static
BuildRequires: libffmpeg-devel-static >= %ffmpeg_version
%else
BuildRequires: libavcodec-devel >= %ffmpeg_version
BuildRequires: libavformat-devel >= %ffmpeg_version
BuildRequires: libavutil-devel >= %ffmpeg_version
BuildRequires: libswscale-devel >= %ffmpeg_version
BuildRequires: libswresample-devel >= %ffmpeg_version
%endif

Requires: dbus

# instead of internal fonts OpenSans
Requires: fonts-ttf-open-sans

# some problems with t_assert
%add_optflags -fpermissive

# disable some warnings
%add_optflags -Wno-strict-aliasing -Wno-unused-variable -Wno-sign-compare -Wno-switch

%description
Telegram is a messaging app with a focus on speed and security, it's super-fast, simple and free.
You can use Telegram on all your devices at the same time - your messages
sync seamlessly across any number of your phones, tablets or computers.

With Telegram, you can send messages, photos, videos and files of any type (doc, zip, mp3, etc),
as well as create groups for up to 1000 people or channels for broadcasting to unlimited audiences.
You can write to your phone contacts and find people by their usernames.
As a result, Telegram is like SMS and email combined - and can take care of all your personal
or business messaging needs.


%prep
%setup

rm -rf Telegram/ThirdParty/variant \
	Telegram/ThirdParty/GSL \
	Telegram/ThirdParty/Catch \
	Telegram/ThirdParty/xxHash \
	Telegram/ThirdParty/lz4 \
	Telegram/ThirdParty/libtgvoip \
	Telegram/ThirdParty/rlottie \
	Telegram/ThirdParty/QR \
	Telegram/ThirdParty/expected

%build
%if_with ffmpeg_static
export PKG_CONFIG_PATH=%_libdir/ffmpeg-static/%_lib/pkgconfig/
%endif

# due precompiled headers
export CCACHE_SLOPPINESS=pch_defines,time_macros

# AppID for Basealt build
# got from https://core.telegram.org/api/obtaining_api_id
%cmake_insource -DDESKTOP_APP_USE_PACKAGED=ON \
    -DTDESKTOP_API_ID=182015 \
    -DTDESKTOP_API_HASH=bb6c3f8fffd8fe6804fc5131a08e1c44 \
    -DVARIANT_INCLUDE_DIRS=%_includedir/libvariant \
    -DDESKTOP_APP_USE_PACKAGED_FONTS:BOOL=ON \
    -DDESKTOP_APP_DISABLE_SPELLCHECK:BOOL=OFF \
    -DTDESKTOP_DISABLE_GTK_INTEGRATION:BOOL=OFF \
    -DDESKTOP_APP_DISABLE_WEBRTC_INTEGRATION:BOOL=ON \
    -DDESKTOP_APP_USE_GLIBC_WRAPS:BOOL=OFF \
    -DDESKTOP_APP_DISABLE_CRASH_REPORTS:BOOL=ON \
    -DTDESKTOP_DISABLE_REGISTER_CUSTOM_SCHEME:BOOL=ON \
    -DTDESKTOP_DISABLE_DESKTOP_FILE_GENERATION:BOOL=ON \
    -DTDESKTOP_FORCE_GTK_FILE_DIALOG:BOOL=ON \
    %nil
#    -DTDESKTOP_USE_PACKAGED_TGVOIP:BOOL=ON \
# check later: -DDESKTOP_APP_ENABLE_IPO_OPTIMIZATIONS:BOOL=ON

%make_build

%install
%makeinstall_std
# XDG files
#install -m644 -D lib/xdg/tg.protocol %buildroot%_Kservices/tg.protocol

ln -s %name %buildroot%_bindir/Telegram
ln -s %name %buildroot%_bindir/telegram
ln -s %name %buildroot%_bindir/telegramdesktop

%files
%_bindir/%name
%_bindir/telegramdesktop
%_bindir/Telegram
%_bindir/telegram
%_desktopdir/telegramdesktop.desktop
#_Kservices/tg.protocol
%_datadir/metainfo/telegramdesktop.appdata.xml
%_iconsdir/hicolor/16x16/apps/telegram.png
%_iconsdir/hicolor/32x32/apps/telegram.png
%_iconsdir/hicolor/48x48/apps/telegram.png
%_iconsdir/hicolor/64x64/apps/telegram.png
%_iconsdir/hicolor/128x128/apps/telegram.png
%_iconsdir/hicolor/256x256/apps/telegram.png
%_iconsdir/hicolor/512x512/apps/telegram.png
#_man1dir/*
%doc README.md

%changelog
