%define _unpackaged_files_terminate_build 1

Name:      trac
Version:   1.3.3
Release:   alt1

Group:     Development/Other
Summary:   Integrated scm, wiki, issue tracker and project environment
Url:       http://trac.edgewall.org/
License:   BSD
BuildArch: noarch

Source:    %name-%version.tar

Source1:   trac-0.9-alt-apache2.conf
Source2:   trac-0.9.4-alt-nginx.cgi.conf
Source3:   trac-0.9.4-alt-nginx.fcgi.conf
Source4:   trac-0.9.4-alt-cherokee.cgi.conf
Source5:   trac-0.9.4-alt-cherokee.fcgi.conf
Source6:   trac-passwd
Source7:   trac.init
Source8:   trac.sysconfig
Source9:   trac-restrict-env
Source10:  Alt-linux-team-bar-small.png
Source11:  trac.service

BuildRequires(pre): rpm-macros-apache2
BuildRequires:      python-devel
BuildRequires:      python-module-setuptools
BuildRequires:      python-module-jinja2

Requires: python-module-genshi >= 0.6
Requires: python-modules-sqlite3
Requires: python-module-clearsilver


%description
Trac is a minimalistic web-based software project management and bug/issue
tracking system. It provides an interface to the Subversion revision control
systems, an integrated wiki, flexible issue tracking and convenient report
facilities.

%package contrib
Summary: Trac contribs
Group: Development/Other
Requires: %name = %version

%description contrib
This package contains trac contribs

%package mod_python
Summary: Trac mod_python web frontend
Group: Development/Other
Requires: %name = %version
Requires: apache2

%description mod_python
This package contains trac mod_python web frontend

%package -n python-module-trac-fcgi
Summary: Trac FastCGI web frontend
Group: Development/Other
Requires: %name = %version
Requires: trac-spawn-fcgi

%description -n python-module-trac-fcgi
This package contains trac FastCGI web frontend

%prep
%setup

cp %SOURCE2 nginx-A.trac.cgi.conf
cp %SOURCE3 nginx-A.trac.fcgi.conf
cp %SOURCE4 cherokee-A.trac.cgi.conf
cp %SOURCE5 cherokee-A.trac.fcgi.conf

%__subst "s|site/your_project_logo.png|common/Alt-linux-team-bar-small.png|g" trac/web/chrome.py

%build
%python_build

%install
%python_install

mkdir -p %buildroot%apache2_addonconfdir
sed -e 's,@DATADIR@,%_datadir,g' \
    -e 's,@AHTDOCSDIR@,%apache2_htdocsdir,g' \
    -e 's,@ACONFDIR@,%apache2_confdir,g' \
    -e 's,@LOCALSTATEDIR@,%_localstatedir,g' \
    %SOURCE1 > %buildroot%apache2_addonconfdir/A.%name.conf
install -d %buildroot%_localstatedir/%name %buildroot%_sysconfdir/%name
touch %buildroot%_sysconfdir/%name/passwd
mkdir -p %buildroot/%_bindir
install -m 755 %SOURCE6 %buildroot/%_bindir
install -m 755 %SOURCE9 %buildroot/%_bindir

install -pD -m 755 %SOURCE7 %buildroot/%_initdir/%name
install -pD -m 644 %SOURCE11 %buildroot%_unitdir/%name.service

mkdir -p %buildroot/%_sysconfdir/sysconfig
install -m 644 %SOURCE8 %buildroot/%_sysconfdir/sysconfig/%name

install -m 644 %SOURCE10 %buildroot%python_sitelibdir/%name/htdocs/Alt-linux-team-bar-small.png

rm -rf %buildroot%python_sitelibdir/{admin,db,mimeview,prefs,search,tests,ticket,timeline,util,web,wiki}

%pre
%_sbindir/groupadd -r -f tracadmin ||:
%_sbindir/useradd -r -g tracadmin -d /var/lib/trac -s /dev/null trac \
    2> /dev/null > /dev/null ||:

%post
%post_service %name

%preun
%preun_service %name

%post -n python-module-trac-fcgi
%post_service trac-spawn-fcgi

%preun -n python-module-trac-fcgi
%preun_service trac-spawn-fcgi

%files
%doc README.* COPYING AUTHORS THANKS
%_bindir/trac-admin
%_bindir/tracd
%_bindir/trac-passwd
%_bindir/trac-restrict-env
%attr(0750,root,tracadmin) %dir %_sysconfdir/%name
%attr(0660,root,tracadmin) %config(noreplace) %_sysconfdir/%name/passwd
%attr(2770,root,tracadmin) %dir %_localstatedir/%name
%python_sitelibdir/*
%_initdir/%name
%_unitdir/%name.service
%_sysconfdir/sysconfig/%name

%exclude %python_sitelibdir/%name/web/modpython_frontend.*
%exclude %python_sitelibdir/%name/web/fcgi_frontend.*
%exclude %python_sitelibdir/%name/web/_fcgi.*

%files contrib
%doc contrib

%files mod_python
%python_sitelibdir/%name/web/modpython_frontend.*
%config(noreplace) %apache2_addonconfdir/A.%name.conf

%files -n python-module-trac-fcgi
%python_sitelibdir/%name/web/fcgi_frontend.*
%python_sitelibdir/%name/web/_fcgi.*
%doc nginx-A.trac.cgi.conf nginx-A.trac.fcgi.conf
%doc cherokee-A.trac.cgi.conf cherokee-A.trac.fcgi.conf


%changelog
