%define _libexecdir %_prefix/libexec/upower
%def_enable gtk_doc
%def_enable check

Name: upower
Version: 0.99.11
Release: alt1

Summary: Power Management Service
License: GPLv2+
Group: System/Libraries
URL: http://cgit.freedesktop.org/upower/
Packager: Valery Inozemtsev <shrek@altlinux.ru>

Provides: DeviceKit-power = 016
Obsoletes: DeviceKit-power < 016
Requires: lib%name = %version-%release

Source: %name-%version.tar
Patch: %name-%version-%release.patch

%define glib_ver 2.34
%define dbus_ver 1.9.18

Requires: dbus >= %dbus_ver

BuildRequires: libgio-devel >= %glib_ver
BuildRequires: gtk-doc libusb-devel libgudev-devel libdbus-devel >= %dbus_ver
BuildRequires: libpolkit-devel libudev-devel gobject-introspection-devel
BuildRequires: libimobiledevice-devel pkgconfig(systemd)
%{?_enable_check:BuildRequires: /proc python3 python3-module-dbusmock libumockdev-gir python3-module-dbus}

%description
UPower provides a daemon, API and command line tools for
managing power devices attached to the system.

%package -n lib%name
Summary: %name libraries
Group: System/Libraries
Provides: libdevkit-power = 016
Obsoletes: libdevkit-power < 016

%description -n lib%name
Libraries for %name

%package -n lib%name-devel
Summary: Development libraries and headers for %name
Group: Development/C
Requires: lib%name = %version-%release
Provides: libdevkit-power-devel = 016
Obsoletes: libdevkit-power-devel < 016

%description -n lib%name-devel
Headers, libraries and API docs for %name

%package -n lib%name-gir
Summary: GObject introspection data for the UPower library
Group: System/Libraries
Requires: lib%name = %version-%release
Provides: libdevkit-power-gir = 016
Obsoletes: libdevkit-power-gir < 016

%description -n lib%name-gir
GObject introspection data for the UPower library

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the UPower library
Group: System/Libraries
BuildArch: noarch
Requires: lib%name-gir = %version-%release lib%name-devel = %version-%release
Provides: libdevkit-power-gir-devel = 016
Obsoletes: libdevkit-power-gir-devel < 016

%description -n lib%name-gir-devel
GObject introspection devel data for the UPower library

%prep
%setup
#%%patch -p1

rm -f acinclude.m4

%build
%autoreconf
%configure \
	%{?_enable_gtk_doc:--enable-gtk-doc} \
	--libexecdir=%_libexecdir \
	--localstatedir=%_var \
	--disable-static
%make_build

%install
%makeinstall_std

%find_lang %name

%check
%ifnarch %ix86
PYTHON=%__python3 %make check
%endif

%files -f %name.lang
%doc AUTHORS NEWS README
%dir %_sysconfdir/UPower
%_sysconfdir/UPower/*.conf
%_unitdir/*
/lib/udev/rules.d/*.rules
%_bindir/*
%_libexecdir/*
%_datadir/dbus-1/system.d/*.conf
%_datadir/dbus-1/system-services/*.service
%_mandir/man?/*
%dir %_var/lib/%name

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc
%_datadir/dbus-1/interfaces/*.xml
%_datadir/gtk-doc/html/*

%files -n lib%name-gir
%_typelibdir/*.typelib

%files -n lib%name-gir-devel
%_girdir/*.gir

%changelog
