Name: valgrind
Version: 3.15.0
Release: alt1

Summary: Valgrind, an open-source memory debugger for GNU/Linux
License: GPLv2+
Group: Development/Other
URL: http://www.valgrind.org/
Source: https://sourceware.org/pub/valgrind/%name-%version.tar

Patch0: valgrind-alt-arm.patch
Patch1: valgrind-alt-loongson-is-mips.patch
Patch2: valgrind-alt-vki_siginfo.patch
Patch3: valgrind-rh-cachegrind-improvements.patch
Patch4: valgrind-rh-helgrind-race-supp.patch
Patch5: valgrind-rh-ldso-supp.patch
Patch6: valgrind-rh-alt-some-stack-protector.patch
Patch104: valgrind-3.15.0-pkglibexecdir.patch
Patch105: valgrind-3.15.0-disable-s390x-z13.patch

# valgrind needs /proc to work
Requires: /proc
%{?!_disable_check:BuildRequires: /proc gdb-light}

BuildRequires: gcc-c++


%description
Valgrind is an instrumentation framework for building dynamic analysis
tools.  There are Valgrind tools that can automatically detect many
memory management and threading bugs, and profile your programs in
detail.  You can also use Valgrind to build new tools.  The Valgrind
distribution currently includes six production-quality tools: a memory
error detector (memcheck, the default tool), two thread error
detectors (helgrind and drd), a cache and branch-prediction profiler
(cachegrind), a call-graph generating cache and branch-prediction
profiler (callgrind), and a heap profiler (massif).

%package devel
Summary: Development files for %name
License: BSD-style
Group: Development/Other
Requires: %name = %version-%release

%description devel
The valgrind-devel subpackage contains header files with macros to
manipulate and query Valgrind's execution from within the client
program.  The resulting executables will still run without Valgrind,
just a little bit more slowly than they otherwise would, but otherwise
unchanged.

When run on Valgrind with --client-perms=yes, Valgrind observes these
macro calls and takes appropriate action.  When run on Valgrind with
--client-perms=no (the default), Valgrind observes these macro calls
but does not take any action as a result.

%package tool-devel
Summary: Header files and libraries for compiling Valgrind tools
Group: Development/Other
Requires: %name-devel = %version-%release

%description tool-devel
The valgrind-tool-devel subpackage contains header files and libraries
needed to compile Valgrind tools separately from the Valgrind core.


%prep
%setup
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch104 -p1
%patch105 -p1

%build
autoreconf -vi

# Filter out some flags that cause lots of valgrind test failures.
# Also filter away -O2, valgrind adds it wherever suitable, but
# not for tests which should be -O0, as they aren't meant to be
# compiled with -O2 unless explicitely requested.
%define optflags_optimization %nil

# Use gdb-light as gdb.
export ac_cv_path_GDB=%_bindir/gdb-light

# Currently there is no usable MPI implementation in Sisyphus.
%configure \
	--without-mpicc

%make_build

%install
%makeinstall_std

mv %buildroot%_docdir/%name{,-%version}
install -m644 -p AUTHORS FAQ.txt NEWS \
	%buildroot%_docdir/%name-%version/

# Most of ELF objects should not be stripped - see README_PACKAGERS
%brp_strip_none %_libexecdir/%name/*

%check
if [ ! -r /proc/self/exe ]; then
	echo '/proc/self/exe is not available, regression test SKIPPED' >&2
	exit
fi

# Make sure a basic binary runs.
./vg-in-place --error-exitcode=1 /bin/echo

%make_build CFLAGS= check ||:

echo "===============TESTING==================="
make nonexp-regtest ||:
find -type f -name '*.diff' |sort
echo "===============END TESTING==============="

%files
%_bindir/*
%_libexecdir/%name/
%exclude %_libdir/%name/lib*.a
%_docdir/%name-%version/
%exclude %_docdir/%name-%version/valgrind_manual.ps
%_mandir/*/*

%files devel
%dir %_includedir/%name/
%_includedir/%name/valgrind.h
%_includedir/%name/callgrind.h
%_includedir/%name/helgrind.h
%_includedir/%name/memcheck.h

%files tool-devel
%_includedir/%name/
%exclude %_includedir/%name/valgrind.h
%exclude %_includedir/%name/callgrind.h
%exclude %_includedir/%name/helgrind.h
%exclude %_includedir/%name/memcheck.h
%dir %_libdir/%name/
%_libdir/%name/lib*.a
%_pkgconfigdir/%name.pc


%changelog
