Name: vcmi
Version: 0.99
Release: alt4

Summary: Open-source project aiming to reimplement HMM3:WoG game engine
Summary(ru_RU.UTF-8): Open-source движок для игры HMM3:WoG
License: GPLv2+
Group: Games/Strategy
URL: http://wiki.vcmi.eu/index.php?title=Main_Page
Packager: Anton Midyukov <antohami@altlinux.org>
Source: %name-%version.tar
Patch1: vcmi-boost-1.66.patch
BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake gcc-c++
BuildRequires: doxygen
BuildRequires: boost-devel
BuildRequires: boost-filesystem-devel
BuildRequires: boost-locale-devel
BuildRequires: boost-program_options-devel
BuildRequires: boost-asio-devel
BuildRequires: boost-interprocess-devel
BuildRequires: pkgconfig(libavcodec)
BuildRequires: pkgconfig(libavdevice)
BuildRequires: pkgconfig(libavformat)
BuildRequires: pkgconfig(libavutil)
BuildRequires: pkgconfig(libpostproc)
BuildRequires: pkgconfig(libswscale)
BuildRequires: pkgconfig(libavresample)
BuildRequires: pkgconfig(libswresample)
BuildRequires: pkgconfig(libavfilter)
BuildRequires: pkgconfig(fuzzylite)
BuildRequires: pkgconfig(minizip)
BuildRequires: pkgconfig(Qt5Network)
BuildRequires: pkgconfig(Qt5Widgets)
BuildRequires: pkgconfig(sdl2)
BuildRequires: pkgconfig(SDL2_image)
BuildRequires: pkgconfig(SDL2_mixer)
BuildRequires: pkgconfig(SDL2_ttf)
BuildRequires: pkgconfig(zlib)

Requires: ffmpeg

%description
The purpose of VCMI project is to rewrite entire HOMM 3: WoG engine from
scratch, giving it new and extended possibilities. We hope to support 
mods and new towns already made by fans but abandoned because of game
code limitations.

VCMI is fan-made open-source project in progress. We already allow
support for maps of any sizes, higher resolutions and extended engine
limits. However, although working, the game is not finished. There are
still many features and functionalities to add, both old and brand new.

As yet VCMI is not standalone program, it uses Wake of Gods files and
graphics. You need to install WoG before running VCMI.

%description -l ru_RU.UTF8
Цель проекта VCMI состоит в том, чтобы переписать полностью движок
HoMM 3: WoG, и тем самым дать ему новые и расширенные возможности.
Мы надеемся реализовать поддержку модов и новых городов, которые уже
сделаны фанатами, но от которых отказались из-за ограничений кода игры.

VCMI это фанатский проект с открытым исходным кодом. Мы уже реализовали
поддержку карт любых размеров, более высокое разрешение и расширенные
возможности движка. Тем не менее хотя игра и работает, она ещё не
закончена. Есть еще много особенностей которые нужно добавить, как 
старых так и новых.

Пока VCMI не отдельная программа, она использует файлы от Wake of Gods.
Вам нужно установить WoG перед запуском VCMI.

%prep
%setup -q
%patch1 -p1
    
%cmake -DLIB_DIR=%_lib/%name \
       -DCMAKE_INSTALL_LIBDIR=%_lib \
       -DCMAKE_SKIP_RPATH=OFF \
       -DENABLE_SDL2=ON

%cmake_build

%install
%cmakeinstall_std
mv %buildroot/%_libdir/%name/libvcmi.so %buildroot/%_libdir/libvcmi.so
rm -f %buildroot%_libdir/*.a

%files
%doc README.md README.linux AUTHORS ChangeLog
%_bindir/%{name}*
%_datadir/%name/
%_desktopdir/*.desktop
%_iconsdir/hicolor/*/apps/*.png
%_libdir/lib%name.so
%_libdir/%name/

%changelog
