%global libweston_major 5

Name:           weston
Version:        5.0.0
Release:        alt1
Summary:        Reference compositor for Wayland
Group:          Graphical desktop/Other
License:        BSD and CC-BY-SA
URL:            http://wayland.freedesktop.org/
Source0:        %name-%version.tar

Packager: Alexey Gladkov <legion@altlinux.ru>

BuildRequires(pre): rpm-build-xdg

BuildRequires: autoconf gcc-c++ pkg-config doxygen
BuildRequires: glibc-devel-static
BuildRequires: libGLES-devel
BuildRequires: libXcursor-devel
BuildRequires: libcairo-devel
BuildRequires: libcolord-devel
BuildRequires: libdbus-devel
BuildRequires: libudev-devel
BuildRequires: libdrm-devel
BuildRequires: libgbm-devel
BuildRequires: libinput-devel
BuildRequires: libjpeg-devel
BuildRequires: liblcms2-devel
BuildRequires: libmtdev-devel
BuildRequires: libpam-devel
BuildRequires: libpixman-devel
BuildRequires: libsystemd-devel
BuildRequires: libva-devel
BuildRequires: libwayland-cursor-devel
BuildRequires: libwayland-egl-devel
BuildRequires: libwayland-server-devel
BuildRequires: libwebp-devel
BuildRequires: libxkbcommon-devel
BuildRequires: wayland-protocols

%description
Weston is the reference wayland compositor that can run on KMS, under X11
or under another compositor.

%package -n lib%name
Summary: Weston compositor libraries
Group:   System/Libraries

%description -n lib%name
This package contains Weston compositor libraries.

%package -n lib%name-devel
Summary:  Development libraries for weston
Group:    Development/C
Requires: %name = %version-%release

%description -n lib%name-devel
Header and Library files for doing development with the weston.

%package devel
Summary:  Development files for weston
Group:    Development/C
Requires: %name = %version-%release

%description devel
Header files for doing development with the weston.

%prep
%setup -q

%build
%autoreconf
%configure \
	--libexecdir=%_libdir/weston/clients \
	--disable-static \
	--disable-setuid-install \
	--disable-libunwind \
	--enable-xwayland \
	--enable-colord \
	--enable-clients \
	--enable-simple-clients \
	--enable-weston-launch \
	--enable-x11-compositor \
	--enable-drm-compositor \
	--enable-wayland-compositor \
	--enable-headless-compositor \
	--enable-fbdev-compositor \
	--enable-screen-sharing \
	--enable-vaapi-recorder \
	--enable-dbus \
	--enable-systemd-login \
	#

%make_build

%install
%make_install install DESTDIR=%buildroot

mkdir -p -- %buildroot/%_xdgconfigdir/weston
sed \
	-e 's,@clientsdir@,%_libdir/weston/clients,g' \
	.gear/weston.ini > %buildroot/%_xdgconfigdir/weston/weston.ini

chmod +s %buildroot/%_bindir/weston-launch

find %buildroot -name \*.la | xargs rm -f

#pre
#groupadd -r -f weston-launch
#useradd -r -g weston-launch -d /dev/null -s /dev/null -n weston-launch >/dev/null 2>&1 ||:

%files
%dir %_xdgconfigdir/weston
%config(noreplace) %_xdgconfigdir/weston/weston.ini
%_bindir/*
%_libdir/weston
%_datadir/weston
%_datadir/wayland-sessions/weston.desktop
%_man1dir/weston*
%_man5dir/weston*
%_man7dir/weston*

%files devel
%_includedir/weston
%_pkgconfigdir/weston.pc

%files -n lib%name
%_libdir/libweston-%libweston_major
%_libdir/libweston*.so.*

%files -n lib%name-devel
%_includedir/libweston-%libweston_major
%_libdir/libweston*.so
%_pkgconfigdir/libweston*.pc

%changelog
