Epoch: 1
Group: Games/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
BuildRequires: /usr/bin/desktop-file-install /usr/bin/doxygen boost-devel libGLU-devel libX11-devel libglvnd-devel libicu-devel python-devel rpm-build-python zlib-devel
# END SourceDeps(oneline)

%filter_from_requires /^.usr.share.fonts.ttf./d
Requires: fonts-ttf-amiri
Requires: fonts-ttf-lklug
Requires: fonts-ttf-wqy-microhei
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global buildno 19
%global buildid build%{buildno}

Name:           widelands
Version:        0
Release:        alt7_0.69.%{buildid}
Summary:        Open source realtime-strategy game

License:        GPLv2+
URL:            http://www.widelands.org
Source0:        https://launchpad.net/widelands/%{buildid}/%{buildid}/+download/widelands-%{buildid}-src-gcc7.tar.bz2
Source1:        %{name}.desktop
Source2:        %{name}.appdata.xml
Patch0:         widelands-build19-ppc64le.patch
Patch1:         widelands-build19-gcc82.patch

BuildRequires: libSDL2-devel
BuildRequires: libSDL2_image-devel
BuildRequires: libSDL2_mixer-devel
BuildRequires: libSDL2_net-devel
BuildRequires: libSDL2_ttf-devel
BuildRequires: boost-complete >= 1.48.0
BuildRequires: ctest cmake
BuildRequires: ctags
BuildRequires: desktop-file-utils libappstream-glib
BuildRequires: gettext gettext-tools
BuildRequires: gcc
BuildRequires: gcc-c++
BuildRequires: libGLEW-devel
BuildRequires: libpng-devel
Requires:      icon-theme-hicolor
# The game contains a copy of these fonts, we replaces these with system fonts
Requires:      fonts-ttf-amiri
Requires:      fonts-ttf-dejavu
Requires:      fonts-ttf-dejavu
Requires:      fonts-ttf-dejavu
Requires:      fonts-otf-drehatlas-widelands
Requires:      fonts-ttf-lklug
Requires:      fonts-ttf-wqy-microhei
Source44: import.info

%description
Widelands is an open source (GPLed), realtime-strategy game, using SDL and
other free libraries, which is still under development. Widelands is inspired
by Settlers II (Bluebyte) and is partly similar to it, so if you know it, you
perhaps will have a thought, what Widelands is all about.


%prep
%setup -q -n widelands-%{buildid}-src-gcc7
%patch0 -p1
%patch1 -p1


%build
mkdir build
pushd build
# We need to set CMAKE_INCLUDE_PATH to /usr for FindLua51.cmake
%{fedora_cmake} \
    -DCMAKE_BUILD_TYPE=Release \
    -DCMAKE_INSTALL_PREFIX=%{_bindir} \
    -DWL_INSTALL_BASEDIR=%{_prefix}/share/%{name} \
    -DWL_INSTALL_DATADIR=%{_prefix}/share/%{name} \
    -DOPTION_BUILD_WEBSITE_TOOLS=OFF \
    ..
%make_build
popd


%install
pushd build
%makeinstall_std
popd

mkdir -p $RPM_BUILD_ROOT%{_datadir}/icons/hicolor/64x64/apps
ln -s /usr/share/%{name}/images/logos/wl-logo-64.png $RPM_BUILD_ROOT%{_datadir}/icons/hicolor/64x64/apps/%{name}.png

mkdir -p $RPM_BUILD_ROOT%{_datadir}/applications
desktop-file-install --dir $RPM_BUILD_ROOT%{_datadir}/applications %{SOURCE1}
mkdir -p $RPM_BUILD_ROOT%{_datadir}/appdata
install -p -m 644 %{SOURCE2} $RPM_BUILD_ROOT%{_datadir}/appdata
appstream-util validate-relax --nonet \
  $RPM_BUILD_ROOT%{_datadir}/appdata/%{name}.appdata.xml

pushd $RPM_BUILD_ROOT
# We don't want this development tool / utility
rm usr/bin/wl_render_richtext

# Replace fonts with system fonts
rm -r usr/share/%{name}/i18n/fonts/amiri
rm -r usr/share/%{name}/i18n/fonts/DejaVu
rm -r usr/share/%{name}/i18n/fonts/MicroHei
rm -r usr/share/%{name}/i18n/fonts/Sinhala
rm -r usr/share/%{name}/i18n/fonts/Widelands/*
ln -s /usr/share/fonts/ttf/amiri usr/share/%{name}/i18n/fonts/amiri
ln -s /usr/share/fonts/ttf/dejavu usr/share/%{name}/i18n/fonts/DejaVu
ln -s /usr/share/fonts/ttf/wqy-microhei usr/share/%{name}/i18n/fonts/MicroHei
ln -s /usr/share/fonts/ttf/lklug usr/share/%{name}/i18n/fonts/Sinhala
ln -s /usr/share/fonts/otf/drehatlas-widelands/Widelands.otf usr/share/%{name}/i18n/fonts/Widelands/Widelands.ttf

# Scripting magic to add proper %%lang() markings to the locale files
find usr/share/widelands/locale/ -maxdepth 1 -type d -name \*_\* | sed -n 's#\(usr/share/widelands/locale/\(.*\)_.*\)#%lang(\2) /\1#p' > %{_builddir}/widelands-%{buildid}-src-gcc7/%{name}.files
find usr/share/widelands/locale/ -maxdepth 1 -type d ! -name "*_*" | sed -n -e 's#\(usr/share/widelands/locale/\(.\+\)\)#%lang(\2) /\1#p' >> %{_builddir}/widelands-%{buildid}-src-gcc7/%{name}.files
find usr/share/widelands/ -mindepth 1 -maxdepth 1 -not -name locale | sed -n 's#\(usr/share/widelands/*\)#/\1#p' >> %{_builddir}/widelands-%{buildid}-src-gcc7/%{name}.files
popd


%files -f %{name}.files
%doc ChangeLog CREDITS
%doc --no-dereference COPYING
%{_bindir}/%{name}
%{_datadir}/icons/hicolor/64x64/apps/%{name}.png
%{_datadir}/appdata/%{name}.appdata.xml
%{_datadir}/applications/%{name}.desktop
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/locale


%changelog
