Name: x264
Version: 148
Release: alt5

Summary: CLI H.264 encoder
License: GPL
Group: Video
Url: http://www.videolan.org/x264.html

Source: %name-%version-%release.tar

BuildRequires: libSDL-devel libx264-devel
BuildRequires: libavformat-devel libavcodec-devel libavdevice-devel libavutil-devel libswscale-devel

%description
%name is a free library for encoding H264/AVC video streams. The code is
written from scratch.
Encoder features:
- CAVLC/CABAC
- Multi-references
- Intra: all macroblock types (16x16, 8x8, and 4x4 with all
  predictions)
- Inter P: all partitions (from 16x16 down to 4x4)
- Inter B: partitions from 16x16 down to 8x8 (including skip/direct)
- Ratecontrol: constant quantizer, single or multipass ABR, optional
  VBV
- Scene cut detection
- Adaptive B-frame placement
- B-frames as references / arbitrary frame order
- 8x8 and 4x4 adaptive spatial transform
- Lossless mode
- Custom quantization matrices
- Parallel encoding of multiple slices.

This package includes CLI based H.264 encoder.

%package utils
Group: Video
Summary: H.264 encoder utils

%description utils
%name is a free library for encoding H264/AVC video streams. The code is
written from scratch.
Encoder features:
- CAVLC/CABAC
- Multi-references
- Intra: all macroblock types (16x16, 8x8, and 4x4 with all
  predictions)
- Inter P: all partitions (from 16x16 down to 4x4)
- Inter B: partitions from 16x16 down to 8x8 (including skip/direct)
- Ratecontrol: constant quantizer, single or multipass ABR, optional
  VBV
- Scene cut detection
- Adaptive B-frame placement
- B-frames as references / arbitrary frame order
- 8x8 and 4x4 adaptive spatial transform
- Lossless mode
- Custom quantization matrices
- Parallel encoding of multiple slices.

This package includes %name encoder utils.

%prep
%setup

%build
%configure \
	--enable-debug \
	--disable-asm \
	--system-libx264

%make_build %name

%install
%make_install DESTDIR=%buildroot install
install -pm0755 tools/countquant_x264.pl %buildroot%_bindir

%files
%_bindir/%name

%files utils
%doc tools/q_matrix_jvt.cfg
%_bindir/countquant_x264.pl

%changelog
