Name: xfce4-power-manager
Version: 1.6.6
Release: alt1
Summary: Power management for the Xfce desktop environment
Summary (ru_RU.UTF8): Утилита расширенного управления питанием для Xfce

Group: Graphical desktop/XFce
License: GPLv2+
Url: https://docs.xfce.org/xfce/xfce4-power-manager/start
Packager: Xfce Team <xfce@packages.altlinux.org>

# Upstream: git://git.xfce.org/xfce/xfce4-power-manager
Source0: %name-%version.tar
Patch: %name-%version-%release.patch

BuildPreReq: rpm-build-xfce4 xfce4-dev-tools
BuildPreReq: libxfconf-devel libxfce4panel-gtk3-devel libxfce4ui-gtk3-devel
BuildRequires: libXext-devel
BuildRequires: libXrandr-devel
BuildRequires: libnotify-devel >= 0.4.1
BuildRequires: libglade-devel > 2.0.0
BuildRequires: libupower-devel
BuildRequires: gettext intltool desktop-file-utils
BuildPreReq: exo-csource

Requires: polkit
Requires: upower

%define _unpackaged_files_terminate_build 1

%description
xfce4-power-manager is a tool for the Xfce desktop environment for
managing profiles of policies which affect power consumption, such as
the display brightness level, display sleep times, or CPU frequency
scaling.

%prep
%setup
%patch -p1

%build
# Don't use git tag in version.
%xfce4_drop_gitvtag xfpm_version_tag configure.ac.in
%xfce4reconf
%configure \
	--enable-maintainer-mode \
	--enable-polkit \
	--enable-dpms \
	--enable-network-manager \
	--with-backend=linux \
	--enable-debug=minimum
%make_build

%install
%makeinstall_std
%find_lang %name

%files -f %name.lang
%doc AUTHORS NEWS README
%config %_sysconfdir/xdg/autostart/%name.desktop
%_bindir/*
%_sbindir/xfpm-power-backlight-helper
%_sbindir/xfce4-pm-helper
%_libdir/xfce4/panel/plugins/*.so
%_desktopdir/*.desktop
%_iconsdir/hicolor/*/*/*.*
%_datadir/xfce4/panel/plugins/*.desktop
%_datadir/polkit-1/actions/*.policy
%_mandir/man?/*
%_datadir/metainfo/*.xml

%exclude %_libdir/xfce4/panel/plugins/*.la

%changelog
