Name: xkeyboard-config
Summary: XML-based XKB configuration registry
Version: 2.25
Release: alt1
Epoch: 1
License: X11/MIT
Group: System/X11
Url: http://gswitchit.sourceforge.net/
Packager: Valery Inozemtsev <shrek@altlinux.ru>

Requires: libX11 >= 1.4.3

Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildArch: noarch
BuildRequires: intltool xkbcomp glib2-devel libX11-devel xorg-util-macros xsltproc

%description
Just XML stuff. Later hopefully will be part of Xorg

%package devel
Summary: XML-based XKB configuration registry development package
Group: Development/Other
Requires: %name = %version-%release

%description devel
XML-based XKB configuration registry development package

%prep
%setup -q
%patch -p1

%build
%autoreconf
%configure \
	--with-xkb-base=%_datadir/X11/xkb \
	--enable-compat-rules \
	--with-xkb-rules-symlink=xorg
%make

for d in compat geometry keycodes symbols types; do
	cd $d
	xkbcomp -lfhlpR -o $d.dir '*'
	cd ../
done

%install
%make DESTDIR=%buildroot install

rm -f %buildroot%_datadir/X11/xkb/compiled

%find_lang %name

%pre
[ ! -d %_datadir/X11/xkb/symbols/pc ] || rm -fr %_datadir/X11/xkb/symbols/pc

%files -f %name.lang
%doc AUTHORS NEWS README COPYING docs/HOWTO.testing docs/HOWTO.transition
%doc docs/README.config docs/README.enhancing docs/README.symbols
%_datadir/X11/xkb
%_man7dir/*.7*

%files devel
%_datadir/pkgconfig/*.pc

%changelog
