%define _unpackaged_files_terminate_build 1

Name: xosview
Version: 1.22
Release: alt1
Summary: An X Window System utility for monitoring system resources
License: GPL-2.0 and BSD-4-Clause-UC
Group: Monitoring
Url: http://xosview.sourceforge.net/

# https://github.com/hills/xosview.git
Source: %name-%version.tar
Source1: xosview16.png
Source2: xosview32.png
Source3: xosview48.png

Patch: xosview-1.21-alt-e2k.patch

BuildRequires: gcc-c++ libXpm-devel libX11-devel desktop-file-utils

%description
The %name utility displays a set of bar graphs which show the current
system state, including memory usage, CPU usage, system load, etc.
Xosview runs under the X Window System.

%prep
%setup
%patch -p1

%build
%make_build OPTFLAGS="${CFLAGS:-%optflags}"

cat > %{name}.desktop <<EOF
[Desktop Entry]
Version=1.0
Type=Application
Name=%name
GenericName=OS Resource Viewer
Comment=
Exec=xosview
Icon=xosview
Categories=Utility;System;Monitor;
Terminal=false
EOF

%install
mkdir -p %buildroot{%_bindir,%_man1dir,%_x11appconfdir}
%make_install install PREFIX=%buildroot%prefix

install -pD -m644 Xdefaults %buildroot%_x11appconfdir/XOsview
install -pD -m644 %SOURCE1  %buildroot%_miconsdir/%name.png
install -pD -m644 %SOURCE2  %buildroot%_niconsdir/%name.png
install -pD -m644 %SOURCE3  %buildroot%_liconsdir/%name.png

desktop-file-install --dir %buildroot%_datadir/applications %{name}.desktop
desktop-file-install --dir %buildroot%_desktopdir \
	--remove-category=Utility \
	%buildroot%_desktopdir/xosview.desktop

%files
%doc COPYING*
%doc CHANGES README.linux TODO
%config %_x11appconfdir/*
%_bindir/*
%_man1dir/*
%_desktopdir/%name.desktop
%_liconsdir/*.png
%_niconsdir/*.png
%_miconsdir/*.png

%changelog
