# vim: set ft=spec: -*- spec -*-

%define _libexecdir /usr/libexec

# xscreensaver RPM macros
%define xss_hack_dir	%_libexecdir/%name
%define xss_conf_dir	%_datadir/%name/config
%define xss_ad_dir	%_sysconfdir/X11/%name/hack.d
#

Name: xscreensaver
Version: 5.43
Release: alt3

Summary: A screen saver and locker for the X window system

License: BSD
Group: Graphical desktop/Other
Url: http://www.jwz.org/xscreensaver

Source: %name-%version.tar

Patch: %name-%version-%release.patch
Patch1: xscreensaver-5.40-do-not-claim-on-old-version.patch
Patch2: xscreensaver-5.43-lcc-is-not-gcc.patch

Source1: %name-%version-ad.tar

Source2: %name.pamd
Source3: %name-update.sh

Source4: xscreensaver-hacks
Source5: xscreensaver-hacks-gl

Source6: ru.po

Source7: xscreensaver-config.xsl
Source8: xscreensaver-config.sh

Requires: xli urlview appres
Requires: %name-hack
Provides: %name-contrib = %EVR
Obsoletes: %name-contrib

Provides: screen-saver-engine

%if_with gnome2
# NB: gnome-screensaver-3.0.0 doesn't contain migration script
BuildPrereq: gnome-screensaver-utils
%endif
BuildRequires: bc imake intltool libGLU-devel libXi-devel libXinerama-devel
BuildRequires: libXmu-devel libXpm-devel libXrandr-devel libXxf86misc-devel
BuildRequires: libXxf86vm-devel libglade-devel libgle-devel libjpeg-devel
BuildRequires: libpam-devel libxml2-devel xorg-cf-files xsltproc

%description
A modular screen saver and locker for the X Window System.
Highly customizable: allows the use of any program that
can draw on the root window as a display mode.

%package -n rpm-build-%name
Summary: A screen saver and locker for the X window system - RPM macros
Group: Development/Other
Conflicts: %name > %EVR
Conflicts: %name < %EVR
Provides: %name-devel = %EVR
Obsoletes: %name-devel <= 5.05-alt1
BuildArch: noarch

%description -n rpm-build-%name
A modular screen saver and locker for the X Window System.
Highly customizable: allows the use of any program that
can draw on the root window as a display mode.

This package contains RPM macros needed to build packages
for additional xscreensaver hacks.

%package hacks
Summary: A screen saver and locker for the X window system - standard hacks
Group: Graphical desktop/Other
Requires: %name = %EVR
Requires: %name-modules = %EVR
Provides: %name-hack = %EVR
# By webcollage...
Requires: netpbm libjpeg-utils
# By noseguy and phosphor
Requires: fortune-mod
BuildArch: noarch

%description hacks
A modular screen saver and locker for the X Window System.
Highly customizable: allows the use of any program that
can draw on the root window as a display mode.

This package contains standard xscreensaver hacks.

%package hacks-gl
Summary: A screen saver and locker for the X window system - GL hacks
Group: Graphical desktop/Other
Requires: %name = %EVR
Requires: %name-modules-gl = %EVR
Provides: %name-hack = %EVR
Provides: %name-gl = %EVR
Obsoletes: %name-gl

%description hacks-gl
A modular screen saver and locker for the X Window System.
Highly customizable: allows the use of any program that
can draw on the root window as a display mode.

This package contains OpenGL xscreensaver hacks.

%package -n desktop-screensaver-modules-xscreensaver
Summary: A screen saver and locker for the X window system - MATE and XFCE Screensaver modules
Group: Graphical desktop/Other
Requires: %name-modules = %EVR
Provides: mate-screensaver-modules-xscreensaver = %EVR
Obsoletes: mate-screensaver-modules-xscreensaver < %EVR
BuildArch: noarch

%description -n desktop-screensaver-modules-xscreensaver
A modular screen saver and locker for the X Window System.
Highly customizable: allows the use of any program that
can draw on the root window as a display mode.

This package contains modules for MATE and XFCE screensavers.

%package -n desktop-screensaver-modules-xscreensaver-gl
Summary: A screen saver and locker for the X window system - MATE and XFCE screensavers modules
Group: Graphical desktop/Other
Requires: %name-modules-gl = %EVR
Provides: mate-screensaver-modules-xscreensaver-gl = %EVR
Obsoletes: mate-screensaver-modules-xscreensaver-gl < %EVR
BuildArch: noarch

%description -n desktop-screensaver-modules-xscreensaver-gl
A modular screen saver and locker for the X Window System.
Highly customizable: allows the use of any program that
can draw on the root window as a display mode.

This package contains OpenGL modules for MATE and XFCE screensavers.

%package modules
Summary: A screen saver and locker for the X window system - standard modules
Group: Graphical desktop/Other
Conflicts: %name < %EVR
Conflicts: %name > %EVR
# By webcollage...
Requires: netpbm libjpeg-utils
# By noseguy and phosphor
Requires: fortune-mod

%description modules
A modular screen saver and locker for the X Window System.
Highly customizable: allows the use of any program that
can draw on the root window as a display mode.

This package contains standard standalone modules.

%package modules-gl
Summary: A screen saver and locker for the X window system - GL modules
Group: Graphical desktop/Other
Conflicts: %name < %EVR
Conflicts: %name > %EVR
# By starwars
Requires: fortune-mod

%description modules-gl
A modular screen saver and locker for the X Window System.
Highly customizable: allows the use of any program that
can draw on the root window as a display mode.

This package contains OpenGL standalone modules.

%package frontend
Summary: A screen saver and locker for the X window system - configuration frontend
Group: Graphical desktop/Other
Requires: %name = %EVR
Provides: %name-gnome = %EVR
Provides: screen-saver-frontend
Obsoletes: %name-gnome

%description frontend
A modular screen saver and locker for the X Window System.
Highly customizable: allows the use of any program that
can draw on the root window as a display mode.

This package contains xscreensaver configuration frontend.

%prep
%setup
%patch -p1
%patch1 -p2
%ifarch %e2k
%patch2 -p2
%endif
cp %SOURCE6 po/ru.po

%build
%autoreconf
%configure \
  --without-motif \
  --with-pam \
  --without-shadow \
  --with-gl \
  --with-pixbuf \
  --with-proc-interrupts
# Hack to install locale files
subst 's,@install_sh@,install,' po/Makefile

%make_build all

%install
mkdir -p %buildroot{%_bindir,%_sysconfdir/{X11/{app-defaults,%name},pam.d},%_datadir/pixmaps,%_rpmlibdir,%_rpmmacrosdir}
%makeinstall_std install_prefix=%buildroot \
  KDEDIR=%_prefix \
  GNOME_BINDIR=%_bindir \
  AD_DIR=%_sysconfdir/X11/app-defaults

install -m640 %_sourcedir/%name.pamd %buildroot%_sysconfdir/pam.d/%name
install -m755 %_sourcedir/%name-update.sh %buildroot%_bindir/update-%name

cat <<EOF >%buildroot%_rpmmacrosdir/%name
%%xss_hack_dir	%xss_hack_dir	
%%xss_conf_dir	%xss_conf_dir	
%%xss_ad_dir	%xss_ad_dir	

# post-install commands (obsoleted by filetrigger)
%%update_xscreensaver	%%{warning %%%%update_xscreensaver is obsolete}
%%clean_xscreensaver	%%{warning %%%%clean_xscreensaver is obsolete}
EOF

cat <<EOF >%buildroot%_rpmlibdir/%name.filetrigger
#!/bin/sh -e

grep -qs '^%xss_ad_dir/' && update-%name ||:
EOF
chmod 755 %buildroot%_rpmlibdir/%name.filetrigger

tar xf %_sourcedir/%name-%version-ad.tar -C %buildroot%_sysconfdir/X11/%name

%find_lang %name

MkModuleFilelists() {
  list="$1" && shift
  name="$1" && shift

  :> "%name-hacks-$name"
  :> "%name-modules-$name"
  :> "%name-gnome-$name"

  while read module; do
    [ "$module" = "providence" ] && continue
    echo "%%config %xss_ad_dir/$module.xss" >> "%name-hacks-$name"
    echo "%xss_conf_dir/$module.xml" >> "%name-hacks-$name"
    echo "%xss_hack_dir/$module" >> "%name-modules-$name"
    [ -f "%buildroot%_man6dir/$module.6" ] && echo "%_man6dir/$module.6*" >> "%name-modules-$name" ||:
    pushd %buildroot%_datadir/applications/screensavers
    %SOURCE8 %buildroot%xss_conf_dir/$module.xml
    popd
    echo "%_datadir/applications/screensavers/xscreensaver-$module.desktop" >> "%name-desktop-$name"
  done < "$list"
}

mkdir -p %buildroot%_datadir/applications/screensavers
MkModuleFilelists %_sourcedir/xscreensaver-hacks std
MkModuleFilelists %_sourcedir/xscreensaver-hacks-gl gl

# Thanks to Obninsk for detection of really bad animation!
find %buildroot -name "*handsy*" -delete

%files
%doc README README.hacking
%verify(not md5 size mtime) %ghost %config(missingok) %_sysconfdir/X11/app-defaults/XScreenSaver
%dir %_sysconfdir/X11/%name
%dir %xss_ad_dir
%config %_sysconfdir/X11/%name/%name.top
%config %_sysconfdir/X11/%name/%name.bottom
%attr(640,root,chkpwd) %config(noreplace) %_sysconfdir/pam.d/*
%attr(2711,root,chkpwd) %_bindir/%name
%_bindir/%name-command
%_bindir/%name-getimage
%_bindir/%name-getimage-file
%_bindir/%name-getimage-video
%_bindir/%name-text
%_bindir/update-%name
%_man1dir/%name.1*
%_man1dir/%name-command.1*
%_man1dir/%name-getimage.1*
%_man1dir/%name-getimage-file.1*
%_man1dir/%name-getimage-video.1*
%_man1dir/%name-text.1*

%dir %_datadir/%name
%_datadir/%name/glade
%dir %xss_conf_dir
%doc %xss_conf_dir/README
%dir %xss_hack_dir

%xss_hack_dir/ljlatest
%_man6dir/ljlatest.6*

%_rpmlibdir/%name.filetrigger

%files frontend -f %name.lang
%_bindir/%name-demo
%_man1dir/%name-demo.1*
%_desktopdir/xscreensaver-properties.desktop
%_datadir/pixmaps/%name.xpm

%files -n rpm-build-%name
%_rpmmacrosdir/%name

%files hacks -f xscreensaver-hacks-std

%files hacks-gl -f xscreensaver-hacks-gl
%_bindir/xscreensaver-gl-helper
%_man6dir/xscreensaver-gl-helper.6*

%files modules -f xscreensaver-modules-std
%dir %xss_hack_dir
%xss_hack_dir/webcollage-helper

%files modules-gl -f xscreensaver-modules-gl
%dir %xss_hack_dir

%files -n desktop-screensaver-modules-xscreensaver -f xscreensaver-desktop-std

%files -n desktop-screensaver-modules-xscreensaver-gl -f xscreensaver-desktop-gl

%changelog
